/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.ProvidedBlockCacheLocDataAccess;
import io.hops.metadata.hdfs.entity.ProvidedBlockCacheLoc;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;

public class ProvidedBlockCacheLocContext
extends BaseEntityContext<Long, ProvidedBlockCacheLoc> {
    private ProvidedBlockCacheLocDataAccess dataAccess;
    private final Map<Long, ProvidedBlockCacheLoc> nullLocs = new HashedMap();

    public ProvidedBlockCacheLocContext(ProvidedBlockCacheLocDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void update(ProvidedBlockCacheLoc loc) throws TransactionContextException {
        super.update((Object)loc);
        if (this.nullLocs.containsKey(loc.getBlockID())) {
            this.nullLocs.remove(loc.getBlockID());
        }
        if (this.isLogTraceEnabled()) {
            this.log("updated-provided-block-cache-loc", new Object[]{"bid", loc.getBlockID(), "sid", loc.getStorageID()});
        }
    }

    public void remove(ProvidedBlockCacheLoc loc) throws TransactionContextException {
        super.remove((Object)loc);
        if (this.isLogTraceEnabled()) {
            this.log("removed-provided-block-cache-loc", new Object[]{"bid", loc.getBlockID(), "sid", loc.getStorageID()});
        }
    }

    public ProvidedBlockCacheLoc find(FinderType<ProvidedBlockCacheLoc> finder, Object ... params) throws TransactionContextException, StorageException {
        ProvidedBlockCacheLoc.Finder clfinder = (ProvidedBlockCacheLoc.Finder)finder;
        switch (clfinder) {
            case ByBlockId: {
                return this.findByPrimaryKey(clfinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    public Collection<ProvidedBlockCacheLoc> findList(FinderType<ProvidedBlockCacheLoc> finder, Object ... params) throws TransactionContextException, StorageException {
        ProvidedBlockCacheLoc.Finder clFinder = (ProvidedBlockCacheLoc.Finder)finder;
        switch (clFinder) {
            case ByBlockIds: {
                return this.batchFinder(clFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    private ProvidedBlockCacheLoc findByPrimaryKey(ProvidedBlockCacheLoc.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        ProvidedBlockCacheLoc result;
        Long blockId = (Long)params[0];
        if (this.contains(blockId)) {
            result = (ProvidedBlockCacheLoc)this.get(blockId);
            this.hit((FinderType)hbFinder, result, new Object[]{"bid", blockId});
        } else {
            if (this.nullLocs.containsKey(blockId)) {
                return null;
            }
            this.aboutToAccessStorage((FinderType)hbFinder, params);
            result = (ProvidedBlockCacheLoc)this.dataAccess.findByBlockID(blockId.longValue());
            if (result != null) {
                this.gotFromDB(blockId, result);
            } else {
                this.nullLocs.put(blockId, null);
            }
            this.miss((FinderType)hbFinder, result, new Object[]{"bid", blockId});
        }
        return result;
    }

    private Collection<ProvidedBlockCacheLoc> batchFinder(ProvidedBlockCacheLoc.Finder hbFinder, Object[] params) throws StorageException, StorageCallPreventedException {
        Long[] blockIds = (Long[])params;
        this.aboutToAccessStorage((FinderType)hbFinder, params);
        Map result = this.dataAccess.findByBlockIDs(blockIds);
        Long[] longArray = result.keySet().iterator();
        while (longArray.hasNext()) {
            long blkId = (Long)longArray.next();
            ProvidedBlockCacheLoc loc = (ProvidedBlockCacheLoc)result.get(blkId);
            this.gotFromDB(blkId, loc);
            this.miss((FinderType)hbFinder, loc, new Object[]{"bid", blkId});
        }
        longArray = blockIds;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long blkId = longArray[i];
            if (result.containsKey(blkId)) continue;
            this.nullLocs.put(blkId, null);
        }
        return result.values();
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded(), this.getModified());
    }

    Long getKey(ProvidedBlockCacheLoc loc) {
        return loc.getBlockID();
    }
}

