/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.transaction.context.BaseReplicaContext;
import io.hops.transaction.context.BlockPK;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CorruptReplicaContext
extends BaseReplicaContext<BlockPK.ReplicaPK, CorruptReplica> {
    CorruptReplicaDataAccess dataAccess;

    public CorruptReplicaContext(CorruptReplicaDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void update(CorruptReplica hopCorruptReplica) throws TransactionContextException {
        super.update(hopCorruptReplica);
        if (this.isLogTraceEnabled()) {
            this.log("added-corrupt", new Object[]{"bid", hopCorruptReplica.getBlockId(), "sid", hopCorruptReplica.getStorageId()});
        }
    }

    @Override
    public void remove(CorruptReplica hopCorruptReplica) throws TransactionContextException {
        super.remove(hopCorruptReplica);
        if (this.isLogTraceEnabled()) {
            this.log("removed-corrupt", new Object[]{"bid", hopCorruptReplica.getBlockId(), "sid", hopCorruptReplica.getStorageId()});
        }
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.prepare(this.getRemoved(), this.getAdded());
    }

    public Collection<CorruptReplica> findList(FinderType<CorruptReplica> finder, Object ... params) throws TransactionContextException, StorageException {
        CorruptReplica.Finder cFinder = (CorruptReplica.Finder)finder;
        switch (cFinder) {
            case ByBlockIdAndINodeId: {
                return this.findByBlockId(cFinder, params);
            }
            case ByINodeId: {
                return this.findByINodeId(cFinder, params);
            }
            case ByINodeIds: {
                return this.findByINodeIds(cFinder, params);
            }
        }
        throw new RuntimeException(UNSUPPORTED_FINDER);
    }

    @Override
    CorruptReplica cloneEntity(CorruptReplica hopCorruptReplica) {
        return this.cloneEntity(hopCorruptReplica, hopCorruptReplica.getInodeId());
    }

    @Override
    CorruptReplica cloneEntity(CorruptReplica hopCorruptReplica, long inodeId) {
        return new CorruptReplica(hopCorruptReplica.getStorageId(), hopCorruptReplica.getBlockId(), inodeId, hopCorruptReplica.getReason());
    }

    BlockPK.ReplicaPK getKey(CorruptReplica hopCorruptReplica) {
        return new BlockPK.ReplicaPK(hopCorruptReplica.getBlockId(), hopCorruptReplica.getInodeId(), hopCorruptReplica.getStorageId());
    }

    private List<CorruptReplica> findByBlockId(CorruptReplica.Finder cFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long blockId = (Long)params[0];
        long inodeId = (Long)params[1];
        List result = null;
        if (this.containsByBlock(blockId) || this.containsByINode(inodeId)) {
            result = this.getByBlock(blockId);
            this.hit((FinderType)cFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)cFinder, params);
            result = this.dataAccess.findByBlockId(blockId, inodeId);
            Collections.sort(result);
            this.gotFromDB(new BlockPK(blockId, null), result);
            this.miss((FinderType)cFinder, result, new Object[]{"bid", blockId, "inodeid", inodeId});
        }
        return result;
    }

    private List<CorruptReplica> findByINodeId(CorruptReplica.Finder cFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long inodeId = (Long)params[0];
        List result = null;
        if (this.containsByINode(inodeId)) {
            result = this.getByINode(inodeId);
            this.hit((FinderType)cFinder, result, new Object[]{"inodeid", inodeId});
        } else {
            this.aboutToAccessStorage((FinderType)cFinder, params);
            result = this.dataAccess.findByINodeId(inodeId);
            this.gotFromDB(new BlockPK(null, inodeId), result);
            this.miss((FinderType)cFinder, result, new Object[]{"inodeid", inodeId});
        }
        return result;
    }

    private List<CorruptReplica> findByINodeIds(CorruptReplica.Finder cFinder, Object[] params) throws StorageCallPreventedException, StorageException {
        long[] inodeIds = (long[])params[0];
        this.aboutToAccessStorage((FinderType)cFinder, params);
        List result = this.dataAccess.findByINodeIds(inodeIds);
        this.miss((FinderType)cFinder, result, new Object[]{"inodeids", Arrays.toString(inodeIds)});
        this.gotFromDB(BlockPK.ReplicaPK.getKeys(inodeIds), result);
        return result;
    }
}

