/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.entity.DirectoryWithQuotaFeature;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.util.EnumCounters;

public class DirectoryWithQuotaFeatureDALAdaptor
extends DalAdaptor<org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature, DirectoryWithQuotaFeature>
implements DirectoryWithQuotaFeatureDataAccess<org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature> {
    private DirectoryWithQuotaFeatureDataAccess<DirectoryWithQuotaFeature> dataAccess;

    public DirectoryWithQuotaFeatureDALAdaptor(DirectoryWithQuotaFeatureDataAccess<DirectoryWithQuotaFeature> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature findAttributesByPk(Long inodeId) throws StorageException {
        return this.convertDALtoHDFS((DirectoryWithQuotaFeature)this.dataAccess.findAttributesByPk(inodeId));
    }

    public void prepare(Collection<org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature> modified, Collection<org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature> removed) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(modified), this.convertHDFStoDAL(removed));
    }

    public DirectoryWithQuotaFeature convertHDFStoDAL(org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature dir) throws StorageException {
        if (dir != null) {
            HashMap<QuotaUpdate.StorageType, Long> typeQuota = new HashMap<QuotaUpdate.StorageType, Long>();
            HashMap<QuotaUpdate.StorageType, Long> typeUsage = new HashMap<QuotaUpdate.StorageType, Long>();
            for (StorageType type : StorageType.asList()) {
                typeQuota.put(QuotaUpdate.StorageType.valueOf((String)type.name()), dir.getQuota().getTypeSpaces().get(type));
                typeUsage.put(QuotaUpdate.StorageType.valueOf((String)type.name()), dir.getSpaceConsumed().getTypeSpaces().get(type));
            }
            DirectoryWithQuotaFeature hia = new DirectoryWithQuotaFeature(dir.getInodeId(), Long.valueOf(dir.getQuota().getNameSpace()), Long.valueOf(dir.getSpaceConsumed().getNameSpace()), Long.valueOf(dir.getQuota().getStorageSpace()), Long.valueOf(dir.getSpaceConsumed().getStorageSpace()), typeQuota, typeUsage);
            return hia;
        }
        return null;
    }

    public org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature convertDALtoHDFS(DirectoryWithQuotaFeature hia) throws StorageException {
        if (hia != null) {
            EnumCounters<StorageType> typeQuotas = new EnumCounters<StorageType>(StorageType.class);
            EnumCounters<StorageType> typeUsage = new EnumCounters<StorageType>(StorageType.class);
            for (StorageType type : StorageType.asList()) {
                typeQuotas.add(type, (Long)hia.getTypeQuota().get(QuotaUpdate.StorageType.valueOf((String)type.name())));
                typeUsage.add(type, (Long)hia.getTypeUsed().get(QuotaUpdate.StorageType.valueOf((String)type.name())));
            }
            org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature dir = new DirectoryWithQuotaFeature.Builder(hia.getInodeId()).nameSpaceQuota(hia.getNsQuota()).storageSpaceQuota(hia.getSSQuota()).spaceUsage(hia.getSSUsed()).nameSpaceUsage(hia.getNsUsed()).typeQuotas(typeQuotas).typeUsages(typeUsage).build();
            return dir;
        }
        return null;
    }

    public Collection<org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature> findAttributesByPkList(List<INodeCandidatePrimaryKey> inodePks) throws StorageException {
        return this.convertDALtoHDFS(this.dataAccess.findAttributesByPkList(inodePks));
    }
}

