/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import java.util.ArrayDeque;
import java.util.Queue;

public class CountersQueue {
    private int available = 0;
    private Queue<Counter> queue = new ArrayDeque<Counter>();

    public synchronized void addCounter(long start, long end) {
        this.addCounter(new Counter(start, end));
    }

    public synchronized void addCounter(Counter counter) {
        this.queue.offer(counter);
        this.available = (int)((long)this.available + (counter.end - counter.start));
    }

    public synchronized long next() {
        Counter c = this.queue.peek();
        while (c != null) {
            if (c.hasNext()) {
                --this.available;
                return c.next();
            }
            this.queue.remove();
            c = this.queue.peek();
        }
        throw new EmptyCountersQueueException();
    }

    public synchronized boolean has(int expectedNumOfIds) {
        return this.available >= expectedNumOfIds && expectedNumOfIds != 0;
    }

    public String toString() {
        return "CountersQueue{available=" + this.available + ", queue=" + this.queue + '}';
    }

    public class EmptyCountersQueueException
    extends RuntimeException {
    }

    public static class Counter {
        private final long start;
        private final long end;
        private long current;

        public Counter(long start, long end) {
            this.start = start;
            this.end = end;
            this.current = start;
        }

        public long next() {
            return this.current++;
        }

        public boolean hasNext() {
            return this.current < this.end;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStart() {
            return this.start;
        }

        public String toString() {
            return "Counter{end=" + this.end + ", current=" + this.current + '}';
        }
    }
}

