/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.BackOff;

public class ExponentialBackOff
implements BackOff {
    public static final long INITIAL_INTERVAL_MILLIS = 100L;
    public static final long MAXIMUM_INTERVAL_MILLIS = 60000L;
    public static final double RANDOMIZATION_FACTOR = 0.5;
    public static final double MULTIPLIER = 1.5;
    public static final int MAXIMUM_RETRIES = 10;
    private long initialIntervalMillis;
    private long maximumIntervalMillis;
    private double randomizationFactor;
    private double multiplier;
    private int maximumRetries;
    private int numberOfRetries;
    private long currentIntervalMillis;

    public ExponentialBackOff() {
        this(new Builder());
    }

    public ExponentialBackOff(Builder builder) {
        this.initialIntervalMillis = builder.initialIntervalMillis;
        this.maximumIntervalMillis = builder.maximumIntervalMillis;
        this.randomizationFactor = builder.randomizationFactor;
        this.multiplier = builder.multiplier;
        this.maximumRetries = builder.maximumRetries;
        this.reset();
    }

    @Override
    public long getBackOffInMillis() {
        if (++this.numberOfRetries > this.maximumRetries) {
            return -1L;
        }
        double delta = this.randomizationFactor * (double)this.currentIntervalMillis;
        double minInterval = (double)this.currentIntervalMillis - delta;
        double maxInterval = (double)this.currentIntervalMillis + delta;
        long interval = (long)(minInterval + Math.random() * (maxInterval - minInterval + 1.0));
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maximumIntervalMillis / this.multiplier ? this.maximumIntervalMillis : (long)((double)this.currentIntervalMillis * this.multiplier);
        return interval;
    }

    @Override
    public void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.numberOfRetries = 0;
    }

    public long getInitialIntervalMillis() {
        return this.initialIntervalMillis;
    }

    public long getMaximumIntervalMillis() {
        return this.maximumIntervalMillis;
    }

    public double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public int getMaximumRetries() {
        return this.maximumRetries;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public static class Builder {
        private long initialIntervalMillis = 100L;
        private long maximumIntervalMillis = 60000L;
        private double randomizationFactor = 0.5;
        private double multiplier = 1.5;
        private int maximumRetries = 10;

        public ExponentialBackOff build() {
            return new ExponentialBackOff(this);
        }

        public Builder setInitialIntervalMillis(long initialIntervalMillis) {
            this.initialIntervalMillis = initialIntervalMillis;
            return this;
        }

        public Builder setMaximumIntervalMillis(long maximumIntervalMillis) {
            this.maximumIntervalMillis = maximumIntervalMillis;
            return this;
        }

        public Builder setRandomizationFactor(double randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public Builder setMultiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder setMaximumRetries(int maximumRetries) {
            this.maximumRetries = maximumRetries;
            return this;
        }
    }
}

