/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.hadoop.security.ssl.SecurityMaterial;

public final class X509SecurityMaterial
extends SecurityMaterial {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final Path keyStoreLocation;
    private final int keyStoreSize;
    private final Path trustStoreLocation;
    private final Path passwdLocation;
    private final int trustStoreSize;
    private ByteBuffer keyStoreMem;
    private String keyStorePass;
    private ByteBuffer trustStoreMem;
    private String trustStorePass;

    public X509SecurityMaterial(Path certFolder, Path keyStoreLocation, Path trustStoreLocation, Path passwdLocation, ByteBuffer kStore, String kStorePass, ByteBuffer tstore, String tstorePass) {
        super(certFolder);
        this.keyStoreLocation = keyStoreLocation;
        this.keyStoreSize = kStore.capacity();
        this.trustStoreLocation = trustStoreLocation;
        this.passwdLocation = passwdLocation;
        this.trustStoreSize = tstore.capacity();
        this.keyStoreMem = kStore;
        this.keyStorePass = kStorePass;
        this.trustStoreMem = tstore;
        this.trustStorePass = tstorePass;
    }

    public X509SecurityMaterial(Path keyStoreLocation, Path trustStoreLocation, Path passwdLocation) {
        this(null, keyStoreLocation, trustStoreLocation, passwdLocation, EMPTY_BUFFER, null, EMPTY_BUFFER, null);
    }

    public Path getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public synchronized int getKeyStoreSize() {
        return this.keyStoreSize;
    }

    public Path getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public Path getPasswdLocation() {
        return this.passwdLocation;
    }

    public int getTrustStoreSize() {
        return this.trustStoreSize;
    }

    public synchronized ByteBuffer getKeyStoreMem() {
        return this.keyStoreMem.asReadOnlyBuffer();
    }

    public synchronized void updateKeyStoreMem(ByteBuffer keyStoreMem) {
        this.keyStoreMem = keyStoreMem;
    }

    public synchronized String getKeyStorePass() {
        return this.keyStorePass;
    }

    public synchronized void updateKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public synchronized ByteBuffer getTrustStoreMem() {
        return this.trustStoreMem.asReadOnlyBuffer();
    }

    public synchronized void updateTrustStoreMem(ByteBuffer trustStoreMem) {
        this.trustStoreMem = trustStoreMem;
    }

    public synchronized String getTrustStorePass() {
        return this.trustStorePass;
    }

    public synchronized void updateTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }
}

