/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public class SecurityMaterial {
    private final Path certFolder;
    private final AtomicBoolean tombstone;
    private STATE state;
    private int requestedApplications;

    public SecurityMaterial(Path certFolder) {
        this.certFolder = certFolder;
        this.requestedApplications = 1;
        this.state = STATE.NEW;
        this.tombstone = new AtomicBoolean(false);
    }

    public Path getCertFolder() {
        return this.certFolder;
    }

    public int getRequestedApplications() {
        return this.requestedApplications;
    }

    public void incrementRequestedApplications() {
        ++this.requestedApplications;
    }

    public void decrementRequestedApplications() {
        --this.requestedApplications;
    }

    public boolean isSafeToRemove() {
        return this.requestedApplications == 0;
    }

    public synchronized void changeState(STATE state) {
        this.state = state;
    }

    public synchronized STATE getState() {
        return this.state;
    }

    public boolean hasBeenCanceled() {
        return this.tombstone.get();
    }

    public synchronized boolean tryToCancel() {
        if (this.state.equals((Object)STATE.NEW)) {
            this.tombstone.set(true);
            return true;
        }
        return false;
    }

    public static enum STATE {
        NEW,
        ONGOING,
        FINISHED;

    }
}

