/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.ssl.KeyManagersReloaderThreadPool;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;

public class ReloadingX509KeyManager
extends X509ExtendedKeyManager {
    private final Log LOG = LogFactory.getLog(ReloadingX509KeyManager.class);
    private final String type;
    private final File location;
    private final String keystorePassword;
    private final String keyPassword;
    private final File passwordFileLocation;
    private final long reloadInterval;
    private final TimeUnit reloadTimeUnit;
    private AtomicReference<X509ExtendedKeyManager> keyManagerLocalRef;
    private long lastLoadedTimestamp;
    private WeakReference<ScheduledFuture> reloader = null;
    private final AtomicBoolean fileExists = new AtomicBoolean(true);
    private int numberOfFailures = 0;

    public ReloadingX509KeyManager(String type, String location, String keystorePassword, String keyPassword, long reloadInterval, TimeUnit reloadTimeUnit) throws GeneralSecurityException, IOException {
        this(type, location, keystorePassword, null, keyPassword, reloadInterval, reloadTimeUnit);
    }

    public ReloadingX509KeyManager(String type, String location, String keystorePassword, String passwordFileLocation, String keyPassword, long reloadInterval, TimeUnit reloadTimeUnit) throws GeneralSecurityException, IOException {
        this.type = type;
        this.location = new File(location);
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.passwordFileLocation = passwordFileLocation != null ? new File(passwordFileLocation) : null;
        this.reloadInterval = reloadInterval;
        this.reloadTimeUnit = reloadTimeUnit;
        this.keyManagerLocalRef = new AtomicReference<X509ExtendedKeyManager>(this.loadKeyManager());
    }

    public void init() {
        if (this.reloader == null) {
            ScheduledFuture task = KeyManagersReloaderThreadPool.getInstance().scheduleTask(new Reloader(), this.reloadInterval, this.reloadTimeUnit);
            this.reloader = new WeakReference<ScheduledFuture>(task);
        }
    }

    public void stop() {
        ScheduledFuture task;
        if (this.reloader != null && (task = (ScheduledFuture)this.reloader.get()) != null) {
            task.cancel(true);
            this.reloader = null;
        }
    }

    @VisibleForTesting
    public long getReloadInterval() {
        return this.reloadInterval;
    }

    @VisibleForTesting
    public TimeUnit getReloadTimeUnit() {
        return this.reloadTimeUnit;
    }

    @VisibleForTesting
    public AtomicBoolean getFileExists() {
        return this.fileExists;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    private boolean needsReload() {
        if (this.location.exists()) {
            if (this.location.lastModified() > this.lastLoadedTimestamp) {
                return true;
            }
        } else {
            this.fileExists.set(false);
        }
        return false;
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.getClientAliases(s, principals);
        }
        return null;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.chooseClientAlias(strings, principals, socket);
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.getServerAliases(s, principals);
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.chooseServerAlias(s, principals, socket);
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.getCertificateChain(s);
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.getPrivateKey(s);
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.chooseEngineClientAlias(keyType, issuers, engine);
        }
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        X509ExtendedKeyManager km = this.keyManagerLocalRef.get();
        if (km != null) {
            return km.chooseEngineServerAlias(keyType, issuers, engine);
        }
        return null;
    }

    private X509ExtendedKeyManager loadKeyManager() throws GeneralSecurityException, IOException {
        KeyManager[] keyManagers;
        String keyPass;
        String keyStorePass;
        KeyStore keyStore = KeyStore.getInstance(this.type);
        if (this.passwordFileLocation != null) {
            keyPass = keyStorePass = FileUtils.readFileToString((File)this.passwordFileLocation).trim();
        } else {
            keyStorePass = this.keystorePassword;
            keyPass = this.keyPassword;
        }
        try (FileInputStream in = new FileInputStream(this.location);){
            keyStore.load(in, keyStorePass.toCharArray());
            this.lastLoadedTimestamp = this.location.lastModified();
            this.LOG.debug((Object)("Loaded keystore file: " + this.location));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        kmf.init(keyStore, keyPass.toCharArray());
        X509ExtendedKeyManager keyManager = null;
        for (KeyManager km : keyManagers = kmf.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            keyManager = (X509ExtendedKeyManager)km;
            break;
        }
        return keyManager;
    }

    private class Reloader
    implements Runnable {
        private final BackOff backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(50L).setMaximumIntervalMillis(2000L).setMaximumRetries(3).build();
        private long backOffTimeout = 0L;

        private Reloader() {
        }

        @Override
        public void run() {
            block8: {
                if (ReloadingX509KeyManager.this.needsReload()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.backOffTimeout);
                        ReloadingX509KeyManager.this.keyManagerLocalRef.set(ReloadingX509KeyManager.this.loadKeyManager());
                        if (this.hasFailed()) {
                            ReloadingX509KeyManager.this.numberOfFailures = 0;
                            this.backOff.reset();
                            this.backOffTimeout = 0L;
                        }
                    }
                    catch (InterruptedException ex) {
                        ReloadingX509KeyManager.this.stop();
                    }
                    catch (Exception ex) {
                        this.backOffTimeout = this.backOff.getBackOffInMillis();
                        ReloadingX509KeyManager.this.numberOfFailures++;
                        if (this.backOffTimeout != -1L) {
                            ReloadingX509KeyManager.this.LOG.debug((Object)("Could not reload Key Manager (using the old), trying again in " + this.backOffTimeout + " ms"));
                            break block8;
                        }
                        ReloadingX509KeyManager.this.LOG.error((Object)"Could not reload Key Manager, stop retrying", (Throwable)ex);
                        ReloadingX509KeyManager.this.stop();
                    }
                } else if (!ReloadingX509KeyManager.this.fileExists.get()) {
                    ReloadingX509KeyManager.this.stop();
                }
            }
        }

        private boolean hasFailed() {
            return this.backOffTimeout > 0L;
        }
    }
}

