/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import io.hops.security.AbstractSecurityActions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;

public final class HopsSecurityActionsFactory<ACTOR extends AbstractSecurityActions> {
    private static final Log LOG = LogFactory.getLog((String)HopsSecurityActionsFactory.class.getName());
    private static volatile HopsSecurityActionsFactory _INSTANCE;
    private final Map<String, ACTOR> actors = new ConcurrentHashMap<String, ACTOR>(2);

    private HopsSecurityActionsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HopsSecurityActionsFactory getInstance() {
        if (_INSTANCE != null) return _INSTANCE;
        Class<HopsSecurityActionsFactory> clazz = HopsSecurityActionsFactory.class;
        synchronized (HopsSecurityActionsFactory.class) {
            if (_INSTANCE != null) return _INSTANCE;
            _INSTANCE = new HopsSecurityActionsFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    public ACTOR getActor(final Configuration conf, final String actorClass) throws Exception {
        AbstractSecurityActions actor = (AbstractSecurityActions)this.actors.computeIfAbsent(actorClass, new Function<String, ACTOR>(){

            @Override
            public ACTOR apply(String s) {
                LOG.debug((Object)("Creating new actor for: " + actorClass));
                return HopsSecurityActionsFactory.this.createActor(conf, s);
            }
        });
        if (actor != null) {
            return (ACTOR)actor;
        }
        throw new RuntimeException("Could not load class " + actorClass);
    }

    private ACTOR createActor(Configuration conf, String actorClass) {
        try {
            Class<?> clazz = conf.getClassByName(actorClass);
            if (clazz != null && !AbstractSecurityActions.class.isAssignableFrom(clazz)) {
                throw new RuntimeException(clazz + " is not " + AbstractSecurityActions.class);
            }
            AbstractSecurityActions actor = (AbstractSecurityActions)ReflectionUtils.newInstance(clazz, conf);
            actor.init(conf);
            actor.start();
            return (ACTOR)actor;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    @VisibleForTesting
    public synchronized void clear(String actorClass) {
        AbstractSecurityActions actor = (AbstractSecurityActions)this.actors.remove(actorClass);
        if (actor != null) {
            LOG.debug((Object)("Removing and stopping actor: " + actorClass));
            actor.stop();
        }
    }

    @VisibleForTesting
    public void register(String actorClass, ACTOR actor) {
        this.actors.put(actorClass, actor);
    }
}

