/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.base.Strings;
import io.hops.security.CertificateLocalizationCtx;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;

public class HopsFileBasedKeyStoresFactory
implements KeyStoresFactory {
    private static final Log LOG = LogFactory.getLog(HopsFileBasedKeyStoresFactory.class);
    private Configuration sslConf;
    private Configuration systemConf;
    private ReloadingX509KeyManager keyManager;
    private KeyManager[] keyManagers;
    private ReloadingX509TrustManager trustManager;
    private TrustManager[] trustManagers;

    @Override
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        HopsSSLCryptoMaterial material = this.loadCryptoMaterial(mode);
        this.createKeyManagers(mode, material);
        this.createTrustManagers(mode, material);
    }

    public HopsSSLCryptoMaterial loadCryptoMaterial(SSLFactory.Mode mode) throws IOException {
        try {
            CertificateLocalizationCtx certificateLocalizationCtx = CertificateLocalizationCtx.getInstance();
            certificateLocalizationCtx.setProxySuperusers(this.systemConf);
            Configuration x509MaterialConf = new Configuration(false);
            x509MaterialConf.set("hops.tls.superuser-material-directory", this.systemConf.get("hops.tls.superuser-material-directory", ""));
            HopsSSLSocketFactory hopsSSLSocketFactory = new HopsSSLSocketFactory();
            hopsSSLSocketFactory.setConf(x509MaterialConf);
            return hopsSSLSocketFactory.configureCryptoMaterial(certificateLocalizationCtx.getCertificateLocalization(), certificateLocalizationCtx.getProxySuperusers());
        }
        catch (Exception ex) {
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            LOG.warn((Object)("Could not locate cryptographic material for <" + currentUser.getUserName() + "> Falling back to ssl-{client,server}.xml"));
            String keystoreLocationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.location");
            String keystoreLocation = this.sslConf.get(keystoreLocationProperty);
            String keystorePasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.password");
            String keystorePassword = this.sslConf.get(keystorePasswordProperty);
            String keyPasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.keypassword");
            String keyPassword = this.sslConf.get(keyPasswordProperty, keystorePassword);
            String truststoreLocationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.truststore.location");
            String truststoreLocation = this.sslConf.get(truststoreLocationProperty);
            String passwordFileLocationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.passwordfile.location");
            String passwordFileLocation = this.sslConf.get(passwordFileLocationProperty, null);
            if (Strings.isNullOrEmpty((String)keystoreLocation) || Strings.isNullOrEmpty((String)truststoreLocation) || Strings.isNullOrEmpty((String)keystorePassword) || Strings.isNullOrEmpty((String)keyPassword)) {
                throw new IOException("Failed to determine cryptographic material for user <" + currentUser.getUserName() + ">. Exhausted all methods!");
            }
            return new HopsSSLCryptoMaterial(keystoreLocation, keystorePassword, keyPassword, truststoreLocation, keystorePassword, passwordFileLocation, true);
        }
    }

    @Override
    public void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.trustManagers = null;
        }
        if (this.keyManager != null) {
            this.keyManager.stop();
            this.keyManager = null;
            this.keyManagers = null;
        }
    }

    @Override
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    @Override
    public void setConf(Configuration conf) {
        this.sslConf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.sslConf;
    }

    public void setSystemConf(Configuration conf) {
        this.systemConf = conf;
    }

    public Configuration getSystemConf() {
        return this.systemConf;
    }

    private void createKeyManagers(SSLFactory.Mode mode, HopsSSLCryptoMaterial material) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.sslConf.getBoolean("hadoop.ssl.require.client.cert", false);
        String keystoreType = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.type"), "jks");
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String keystoreLocation = material.getKeyStoreLocation();
            if (Strings.isNullOrEmpty((String)keystoreLocation)) {
                throw new GeneralSecurityException("Could not identify correct keystore");
            }
            String keystorePassword = material.getKeyStorePassword();
            if (Strings.isNullOrEmpty((String)keystorePassword)) {
                throw new GeneralSecurityException("Could not load keystore password");
            }
            String keyPassword = material.getKeyPassword();
            if (Strings.isNullOrEmpty((String)keyPassword)) {
                throw new GeneralSecurityException("Could not load key password");
            }
            long keyStoreReloadInterval = this.sslConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.reload.interval"), 10000L);
            String timeUnitStr = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
            TimeUnit reloadTimeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
            String passwordFileLocation = material.getPasswordFileLocation();
            this.keyManager = new ReloadingX509KeyManager(keystoreType, keystoreLocation, keystorePassword, passwordFileLocation, keyPassword, keyStoreReloadInterval, reloadTimeUnit);
            this.keyManager.init();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(mode.toString() + " Loaded KeyStore: " + keystoreLocation));
            }
            this.keyManagers = new KeyManager[]{this.keyManager};
        } else {
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(null, null);
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
            keyMgrFactory.init(keyStore, null);
            this.keyManagers = keyMgrFactory.getKeyManagers();
        }
    }

    private void createTrustManagers(SSLFactory.Mode mode, HopsSSLCryptoMaterial material) throws IOException, GeneralSecurityException {
        String truststoreType = this.sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.truststore.type"), "jks");
        String truststoreLocation = material.getTrustStoreLocation();
        if (Strings.isNullOrEmpty((String)truststoreLocation)) {
            throw new GeneralSecurityException("Could not identify correct truststore");
        }
        String truststorePassword = material.getTrustStorePassword();
        if (Strings.isNullOrEmpty((String)truststorePassword)) {
            throw new GeneralSecurityException("Could not load truststore password");
        }
        String passwordFileLocation = material.getPasswordFileLocation();
        long truststoreReloadInterval = this.sslConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, "ssl.{0}.truststore.reload.interval"), 10000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(mode.toString() + " TrustStore: " + truststoreLocation));
        }
        this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, passwordFileLocation, truststoreReloadInterval);
        this.trustManager.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(mode.toString() + " Loaded TrustStore: " + truststoreLocation));
        }
        this.trustManagers = new TrustManager[]{this.trustManager};
    }
}

