/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class AbstractSecurityActions
extends CompositeService {
    public static final String API_KEY_AUTH_HEADER_CONTENT = "ApiKey %s";
    public static final String HOPSWORKS_API_kEY_PROP = "hops.hopsworks-api-key";
    public static final String MAX_CONNECTIONS_PER_ROUTE = "hops.security-actions.max-connections-per-route";
    protected static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private static final Set<Integer> ACCEPTABLE_HTTP_RESPONSES = new HashSet<Integer>(2);
    protected CloseableHttpClient httpClient;
    protected HttpHost remoteHost;
    protected Gson parser = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    private PoolingHttpClientConnectionManager httpConnectionManager;
    private String apiKey;

    public AbstractSecurityActions(String name) {
        super(name);
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        Configuration sslConf = new Configuration(false);
        String sslServer = conf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        sslConf.addResource(sslServer);
        this.apiKey = sslConf.get(HOPSWORKS_API_kEY_PROP, "empty-api-key");
        this.remoteHost = HttpHost.create((String)conf.get("hops.hopsworks.host", "https://127.0.0.1"));
        super.serviceInit(conf);
    }

    protected PoolingHttpClientConnectionManager createHTTPConnectionManager(Configuration conf) throws GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(conf.getInt(MAX_CONNECTIONS_PER_ROUTE, 100));
        return connectionManager;
    }

    @Override
    protected void serviceStart() throws Exception {
        this.httpConnectionManager = this.createHTTPConnectionManager(this.getConfig());
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        super.serviceStop();
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    protected void checkHTTPResponseCode(HttpResponse response, String extraMessage) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (!ACCEPTABLE_HTTP_RESPONSES.contains(code)) {
            throw new IOException("HTTP error, response code " + code + " Reason: " + response.getStatusLine().getReasonPhrase() + " Message: " + extraMessage);
        }
    }

    protected void setAuthenticationHeader(HttpRequest request) {
        String authHeader = String.format(API_KEY_AUTH_HEADER_CONTENT, this.apiKey);
        request.addHeader("Authorization", authHeader);
    }

    protected void addJSONContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.APPLICATION_JSON.toString());
    }

    protected void addTextPlainContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.TEXT_PLAIN.toString());
    }

    private void addContentTypeHeader(HttpRequest request, String contentType) {
        request.addHeader("Content-Type", contentType);
    }

    static {
        ACCEPTABLE_HTTP_RESPONSES.add(200);
        ACCEPTABLE_HTTP_RESPONSES.add(204);
    }
}

