/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leader_election.node;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.proto.ActiveNodeProtos;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ActiveNodePBImpl
implements ActiveNode {
    protected ActiveNodeProtos.ActiveNodeProto proto = ActiveNodeProtos.ActiveNodeProto.getDefaultInstance();
    protected ActiveNodeProtos.ActiveNodeProto.Builder builder = null;
    protected boolean viaProto = false;
    InetSocketAddress rpcAddressForDatanodes = null;
    InetSocketAddress rpcAddressForClients = null;

    public ActiveNodePBImpl(ActiveNodeProtos.ActiveNodeProto proto) {
        this(proto.getId(), proto.getRpcHostname(), proto.getRpcIpAddress(), proto.getRpcPort(), proto.getHttpAddress(), proto.getServiceIpAddress(), proto.getServicePort(), proto.getLocationDomainId());
    }

    public ActiveNodePBImpl(long id, String hostname, String ipAddress, int port, String httpAddress, String serviceRpcIp, int serviceRpcPort) {
        this(id, hostname, ipAddress, port, httpAddress, serviceRpcIp, serviceRpcPort, 0);
    }

    public ActiveNodePBImpl(long id, String hostname, String ipAddress, int port, String httpAddress, String serviceRpcIp, int serviceRpcPort, int locationDomainId) {
        this.maybeInitBuilder();
        this.builder.setId(id);
        this.builder.setRpcHostname(hostname);
        this.builder.setRpcIpAddress(ipAddress);
        this.builder.setRpcPort(port);
        this.builder.setHttpAddress(httpAddress);
        this.builder.setServiceIpAddress(serviceRpcIp);
        this.builder.setServicePort(serviceRpcPort);
        this.builder.setLocationDomainId(locationDomainId);
    }

    public ActiveNodeProtos.ActiveNodeProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    protected void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = ActiveNodeProtos.ActiveNodeProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public String getHostname() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRpcHostname();
    }

    public void setHostname(String hostname) {
        this.maybeInitBuilder();
        this.builder.setRpcHostname(hostname);
    }

    @Override
    public long getId() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getId();
    }

    public void setId(long id) {
        this.maybeInitBuilder();
        this.builder.setId(id);
    }

    @Override
    public String getRpcServerIpAddress() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRpcIpAddress();
    }

    public void setIpAddress(String ipAddress) {
        this.maybeInitBuilder();
        this.builder.setRpcIpAddress(ipAddress);
    }

    @Override
    public int getRpcServerPort() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getRpcPort();
    }

    public void setPort(int port) {
        this.maybeInitBuilder();
        this.builder.setRpcPort(port);
    }

    @Override
    public String getHttpAddress() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getHttpAddress();
    }

    @Override
    public int getLocationDomainId() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getLocationDomainId();
    }

    public void setHttpAddress(String httpAddress) {
        this.maybeInitBuilder();
        this.builder.setHttpAddress(httpAddress);
    }

    @Override
    public String getServiceRpcIpAddress() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getServiceIpAddress();
    }

    public void setServiceRpcIpAddress(String serviceRpcIpAddress) {
        this.maybeInitBuilder();
        this.builder.setServiceIpAddress(serviceRpcIpAddress);
    }

    @Override
    public int getServiceRpcPort() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getServicePort();
    }

    public void setServiceRpcPort(int port) {
        this.maybeInitBuilder();
        this.builder.setServicePort(port);
    }

    @Override
    public InetSocketAddress getRpcServerAddressForDatanodes() {
        if (this.rpcAddressForDatanodes != null) {
            return this.rpcAddressForDatanodes;
        }
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.rpcAddressForDatanodes = p.getServicePort() != 0 && p.getServiceIpAddress() != "" ? ActiveNodePBImpl.createSocketAddrForHost(p.getServiceIpAddress(), p.getServicePort()) : this.getRpcServerAddressForClients();
        return this.rpcAddressForDatanodes;
    }

    @Override
    public InetSocketAddress getRpcServerAddressForClients() {
        ActiveNodeProtos.ActiveNodeProtoOrBuilder p;
        if (this.rpcAddressForClients != null) {
            return this.rpcAddressForClients;
        }
        ActiveNodeProtos.ActiveNodeProtoOrBuilder activeNodeProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (p.getRpcPort() == 0 || p.getRpcIpAddress() == "") {
            return null;
        }
        this.rpcAddressForClients = ActiveNodePBImpl.createSocketAddrForHost(p.getRpcIpAddress(), p.getRpcPort());
        return this.rpcAddressForClients;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActiveNode)) {
            return false;
        }
        ActiveNode that = (ActiveNode)obj;
        return this.getRpcServerAddressForClients().equals(that.getRpcServerAddressForClients());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.getRpcServerAddressForClients().hashCode();
        return hash;
    }

    @Override
    public int compareTo(ActiveNode o) {
        if (this.getId() < o.getId()) {
            return -1;
        }
        if (this.getId() == o.getId()) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        String msg = "Active NN (" + this.getId() + ") Client's RPC: " + this.getRpcServerAddressForClients() + " DataNode's RPC: " + this.getRpcServerAddressForDatanodes();
        return msg;
    }

    public static InetSocketAddress createSocketAddrForHost(String host, int port) {
        InetSocketAddress addr;
        try {
            InetAddress iaddr = InetAddress.getByName(host);
            if (host != null) {
                iaddr = InetAddress.getByAddress(host, iaddr.getAddress());
            }
            addr = new InetSocketAddress(iaddr, port);
        }
        catch (UnknownHostException e) {
            addr = InetSocketAddress.createUnresolved(host, port);
        }
        return addr;
    }
}

