/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import sun.security.x509.X500Name;

public class HopsX509AuthenticationHandler
implements AuthenticationHandler {
    public static final String TYPE = "hops.x509";
    private static final Pattern HOPSWORKS_PROJECT_USERNAME = Pattern.compile(".+__.+");
    private final String type;

    public HopsX509AuthenticationHandler() {
        this(TYPE);
    }

    public HopsX509AuthenticationHandler(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void init(Properties config) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String username;
        X509Certificate peerCertificate = this.getPeerX509Certificate(request);
        X500Name name = new X500Name(peerCertificate.getSubjectX500Principal().getName("RFC2253"));
        String locality = name.getLocality();
        String commonName = name.getCommonName();
        Matcher matcher = null;
        if (commonName != null) {
            matcher = HOPSWORKS_PROJECT_USERNAME.matcher(commonName);
        }
        if (locality == null && matcher != null && matcher.matches()) {
            username = commonName;
        } else if (locality != null) {
            username = locality;
        } else {
            throw new AuthenticationException("Could not authenticate user from x509 Subject " + name.toString());
        }
        return new AuthenticationToken(username, username, this.getType());
    }

    private X509Certificate getPeerX509Certificate(HttpServletRequest request) throws AuthenticationException {
        X509Certificate[] peerCertificates = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (peerCertificates == null || peerCertificates.length == 0) {
            throw new AuthenticationException("HTTP request does not contain peer certificate");
        }
        return peerCertificates[0];
    }
}

