/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import com.microsoft.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import java.net.SocketAddress;
import java.util.Objects;
import reactor.netty.http.server.logging.AbstractAccessLogArgProvider;
import reactor.util.annotation.Nullable;

final class AccessLogArgProviderH2
extends AbstractAccessLogArgProvider<AccessLogArgProviderH2> {
    static final String H2_PROTOCOL_NAME = "HTTP/2.0";
    Http2HeadersFrame requestHeaders;
    Http2HeadersFrame responseHeaders;

    AccessLogArgProviderH2(@Nullable SocketAddress remoteAddress) {
        super(remoteAddress);
    }

    AccessLogArgProviderH2 requestHeaders(Http2HeadersFrame requestHeaders) {
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders");
        this.onRequest();
        return this.get();
    }

    AccessLogArgProviderH2 responseHeaders(Http2HeadersFrame responseHeaders) {
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders");
        return this.get();
    }

    @Override
    @Nullable
    public CharSequence status() {
        return this.responseHeaders == null ? null : this.responseHeaders.headers().status();
    }

    @Override
    @Nullable
    public CharSequence requestHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.requestHeaders == null ? null : (CharSequence)this.requestHeaders.headers().get(name);
    }

    @Override
    @Nullable
    public CharSequence responseHeader(CharSequence name) {
        Objects.requireNonNull(name, "name");
        return this.responseHeaders == null ? null : (CharSequence)this.responseHeaders.headers().get(name);
    }

    @Override
    void onRequest() {
        super.onRequest();
        if (this.requestHeaders != null) {
            this.method = this.requestHeaders.headers().method();
            this.uri = this.requestHeaders.headers().path();
            this.protocol = H2_PROTOCOL_NAME;
        }
    }

    @Override
    void clear() {
        super.clear();
        this.requestHeaders = null;
        this.responseHeaders = null;
    }

    @Override
    public AccessLogArgProviderH2 get() {
        return this;
    }
}

