/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.buffer.ByteBufHolder;
import com.microsoft.shaded.io.netty.channel.ChannelDuplexHandler;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.channel.ChannelPromise;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpRequest;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpResponse;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.microsoft.shaded.io.netty.handler.codec.http.LastHttpContent;
import com.microsoft.shaded.io.netty.util.concurrent.Future;
import com.microsoft.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;

final class HttpServerMetricsHandler
extends ChannelDuplexHandler {
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final HttpServerMetricsRecorder recorder;
    final Function<String, String> uriTagValue;

    HttpServerMetricsHandler(HttpServerMetricsRecorder recorder, @Nullable Function<String, String> uriTagValue) {
        this.recorder = recorder;
        this.uriTagValue = uriTagValue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            if (((HttpResponse)msg).status().equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
                if (channelOps instanceof HttpServerOperations) {
                    HttpServerOperations ops = (HttpServerOperations)channelOps;
                    String path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                    String method = ops.method().name();
                    String status = ops.status().codeAsText().toString();
                    this.recorder.recordDataSentTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                    if (this.dataReceivedTime != 0L) {
                        this.recorder.recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                    } else {
                        this.recorder.recordResponseTime(path, method, status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                    }
                    this.recorder.recordDataSent(ops.remoteAddress(), path, this.dataSent);
                    this.dataSent = 0L;
                }
            }));
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpServerOperations) {
                HttpServerOperations ops = (HttpServerOperations)channelOps;
                String path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                String method = ops.method().name();
                this.recorder.recordDataReceivedTime(path, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
                this.recorder.recordDataReceived(ops.remoteAddress(), path, this.dataReceived);
            }
            this.dataReceived = 0L;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpServerOperations) {
            HttpServerOperations ops = (HttpServerOperations)channelOps;
            this.recorder.incrementErrorsCount(ops.remoteAddress(), this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path));
        }
        ctx.fireExceptionCaught(cause);
    }
}

