/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import com.microsoft.shaded.io.netty.resolver.AddressResolverGroup;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import reactor.core.publisher.Mono;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;

public final class HttpResources
extends TcpResources {
    static final BiFunction<LoopResources, ConnectionProvider, HttpResources> ON_HTTP_NEW = HttpResources::new;
    static final AtomicReference<HttpResources> httpResources = new AtomicReference();

    public static void disposeLoopsAndConnections() {
        HttpResources resources = httpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return HttpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout, "timeout");
        return Mono.defer(() -> {
            HttpResources resources = httpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    public static HttpResources get() {
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources reset() {
        HttpResources.disposeLoopsAndConnections();
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(ConnectionProvider provider) {
        return HttpResources.getOrCreate(httpResources, null, provider, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(LoopResources loops) {
        return HttpResources.getOrCreate(httpResources, loops, null, ON_HTTP_NEW, "http");
    }

    HttpResources(LoopResources loops, ConnectionProvider provider) {
        super(loops, provider);
    }

    @Override
    public AddressResolverGroup<?> getOrCreateDefaultResolver() {
        return super.getOrCreateDefaultResolver();
    }
}

