/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.buffer.ByteBufHolder;
import com.microsoft.shaded.io.netty.channel.Channel;
import com.microsoft.shaded.io.netty.channel.ChannelFuture;
import com.microsoft.shaded.io.netty.channel.ChannelFutureListener;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.channel.ChannelPromise;
import com.microsoft.shaded.io.netty.channel.DefaultChannelPromise;
import com.microsoft.shaded.io.netty.channel.EventLoop;
import com.microsoft.shaded.io.netty.util.IllegalReferenceCountException;
import com.microsoft.shaded.io.netty.util.ReferenceCountUtil;
import com.microsoft.shaded.io.netty.util.concurrent.Future;
import com.microsoft.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.netty.channel.AbortedException;
import reactor.netty.channel.MonoSend;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class MonoSendMany<I, O>
extends MonoSend<I, O>
implements Scannable {
    static final Object KEY_ON_DISCARD;
    final Publisher<? extends I> source;
    final Predicate<I> predicate;

    static MonoSendMany<ByteBuf, ByteBuf> byteBufSource(Publisher<? extends ByteBuf> source, Channel channel, Predicate<ByteBuf> predicate) {
        return new MonoSendMany<ByteBuf, ByteBuf>(source, channel, predicate, TRANSFORMATION_FUNCTION_BB, CONSUMER_NOCHECK_CLEANUP, SIZE_OF_BB);
    }

    static MonoSendMany<?, ?> objectSource(Publisher<?> source, Channel channel, Predicate<Object> predicate) {
        return new MonoSendMany(source, channel, predicate, TRANSFORMATION_FUNCTION, CONSUMER_NOCHECK_CLEANUP, SIZE_OF);
    }

    MonoSendMany(Publisher<? extends I> source, Channel channel, Predicate<I> predicate, Function<? super I, ? extends O> transformer, Consumer<? super I> sourceCleanup, ToIntFunction<O> sizeOf) {
        super(channel, transformer, sourceCleanup, sizeOf);
        this.source = Objects.requireNonNull(source, "source publisher cannot be null");
        this.predicate = Objects.requireNonNull(predicate, "predicate cannot be null");
    }

    @Override
    public void subscribe(CoreSubscriber<? super Void> destination) {
        this.source.subscribe(new SendManyInner(this, destination));
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return 128;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    static <T> int wipIncrement(AtomicIntegerFieldUpdater<T> updater, T instance) {
        int wip;
        do {
            if ((wip = updater.get(instance)) != Integer.MIN_VALUE) continue;
            return Integer.MIN_VALUE;
        } while (!updater.compareAndSet(instance, wip, wip + 1));
        return wip;
    }

    static <T> void discardWithTermination(AtomicIntegerFieldUpdater<T> updater, T instance, Queue<?> q, Context context) {
        int wip;
        do {
            wip = updater.get(instance);
            Operators.onDiscardQueueWithClear(q, context, null);
        } while (!updater.compareAndSet(instance, wip, Integer.MIN_VALUE));
    }

    static <T> void discardAsyncWithTermination(AtomicIntegerFieldUpdater<T> updater, T instance, Queue<?> q) {
        int wip;
        do {
            wip = updater.get(instance);
            q.clear();
        } while (!updater.compareAndSet(instance, wip, Integer.MIN_VALUE));
    }

    static {
        Context context = Operators.enableOnDiscard(null, o -> {});
        Map.Entry entry = context.stream().findAny().orElse(null);
        KEY_ON_DISCARD = entry != null ? entry.getKey() : null;
    }

    static final class Completion
    extends Exception {
        static final Completion INSTANCE = new Completion();
        private static final long serialVersionUID = 8284666103614054915L;

        Completion() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class SendManyInner<I, O>
    implements CoreSubscriber<I>,
    Subscription,
    Fuseable,
    Context,
    Consumer<I>,
    ChannelFutureListener,
    Runnable,
    Scannable,
    ChannelPromise {
        final ChannelHandlerContext ctx;
        final EventLoop eventLoop;
        final MonoSendMany<I, O> parent;
        final CoreSubscriber<? super Void> actual;
        final Context actualContext;
        final Runnable asyncFlush;
        volatile Subscription s;
        volatile int wip;
        Queue<I> queue;
        int pending;
        int requested;
        int sourceMode;
        boolean needFlush;
        Throwable terminalSignal;
        int nextRequest;
        static final AtomicIntegerFieldUpdater<SendManyInner> WIP = AtomicIntegerFieldUpdater.newUpdater(SendManyInner.class, "wip");
        static final AtomicReferenceFieldUpdater<SendManyInner, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(SendManyInner.class, Subscription.class, "s");

        SendManyInner(MonoSendMany<I, O> parent, CoreSubscriber<? super Void> actual) {
            this.parent = parent;
            this.actual = actual;
            this.actualContext = actual.currentContext();
            this.requested = 128;
            this.ctx = parent.ctx;
            this.eventLoop = this.ctx.channel().eventLoop();
            this.asyncFlush = new AsyncFlush();
            this.ctx.channel().closeFuture().addListener(this);
        }

        @Override
        public Context currentContext() {
            return this;
        }

        @Override
        public void cancel() {
            if (!Operators.terminate(SUBSCRIPTION, this)) {
                return;
            }
            int wip = MonoSendMany.wipIncrement(WIP, this);
            if (wip == 0) {
                this.onInterruptionCleanup();
            }
        }

        @Override
        public void onComplete() {
            if (this.terminalSignal != null) {
                return;
            }
            this.terminalSignal = Completion.INSTANCE;
            this.trySchedule();
        }

        @Override
        public void onError(Throwable t) {
            if (this.terminalSignal != null) {
                Operators.onErrorDropped(t, this.actualContext);
                return;
            }
            if (t instanceof ClosedChannelException) {
                t = new AbortedException(t);
            }
            this.terminalSignal = t;
            this.trySchedule();
        }

        @Override
        public void onNext(I t) {
            if (this.sourceMode == 2) {
                this.trySchedule();
                return;
            }
            if (this.terminalSignal != null) {
                this.parent.sourceCleanup.accept(t);
                Operators.onDiscard(t, this.actualContext);
                return;
            }
            if (!this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue is full: Reactive Streams source doesn't respect backpressure"), t, this.actualContext));
                return;
            }
            this.trySchedule();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.terminalSignal = Completion.INSTANCE;
                        this.actual.onSubscribe(this);
                        this.trySchedule();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe(this);
                        s.request(128L);
                        return;
                    }
                }
                this.queue = Queues.get(128).get();
                this.actual.onSubscribe(this);
                s.request(128L);
            } else {
                this.queue = Queues.empty().get();
            }
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            if (Operators.terminate(SUBSCRIPTION, this)) {
                int wip = MonoSendMany.wipIncrement(WIP, this);
                if (wip == 0) {
                    this.onInterruptionCleanup();
                }
                this.actual.onComplete();
            }
        }

        @Override
        public void run() {
            Queue<I> queue = this.queue;
            try {
                int missed = 1;
                do {
                    I sourceMessage;
                    int r = this.requested;
                    while ((Integer.MAX_VALUE == r || r-- > 0) && (sourceMessage = queue.poll()) != null) {
                        if (this.s == Operators.cancelledSubscription()) {
                            this.parent.sourceCleanup.accept(sourceMessage);
                            Operators.onDiscard(sourceMessage, this.actualContext);
                            this.onInterruptionCleanup();
                            return;
                        }
                        Object encodedMessage = this.parent.transformer.apply(sourceMessage);
                        if (encodedMessage == null) {
                            if (!this.parent.predicate.test(sourceMessage)) continue;
                            ++this.nextRequest;
                            this.needFlush = false;
                            this.ctx.flush();
                            continue;
                        }
                        int readableBytes = this.parent.sizeOf.applyAsInt(encodedMessage);
                        if (readableBytes == 0 && !(encodedMessage instanceof ByteBufHolder)) {
                            ReferenceCountUtil.release(encodedMessage);
                            ++this.nextRequest;
                            continue;
                        }
                        ++this.pending;
                        this.ctx.write(encodedMessage, this);
                        if (this.parent.predicate.test(sourceMessage) || !this.ctx.channel().isWritable() || (long)readableBytes > this.ctx.channel().bytesBeforeUnwritable()) {
                            this.needFlush = false;
                            this.ctx.flush();
                            continue;
                        }
                        this.needFlush = true;
                    }
                    if (this.needFlush && this.pending != 0) {
                        this.needFlush = false;
                        this.eventLoop.execute(this.asyncFlush);
                    }
                    if (Operators.cancelledSubscription() == this.s) {
                        this.onInterruptionCleanup();
                        return;
                    }
                    if (this.checkTerminated() && queue.isEmpty()) {
                        this.ctx.channel().closeFuture().removeListener(this);
                        Throwable t = this.terminalSignal;
                        if (t == Completion.INSTANCE) {
                            this.actual.onComplete();
                        } else {
                            this.actual.onError(t);
                        }
                        return;
                    }
                    int nextRequest = this.nextRequest;
                    if (this.terminalSignal != null || nextRequest == 0) continue;
                    this.nextRequest = 0;
                    this.s.request(nextRequest);
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }
            catch (Throwable t) {
                this.onInterruptionCleanup();
                if (Operators.terminate(SUBSCRIPTION, this)) {
                    this.actual.onError(t);
                }
                Operators.onErrorDropped(t, this.actualContext);
            }
        }

        void onInterruptionCleanup() {
            this.ctx.channel().closeFuture().removeListener(this);
            Queue<I> queue = this.queue;
            if (queue == null) {
                return;
            }
            if (this.sourceMode == 2) {
                MonoSendMany.discardAsyncWithTermination(WIP, this, queue);
            } else {
                Context context = this.currentContext();
                MonoSendMany.discardWithTermination(WIP, this, queue, context);
            }
        }

        boolean checkTerminated() {
            return this.pending == 0 && this.terminalSignal != null;
        }

        void trySchedule() {
            block7: {
                int wip = MonoSendMany.wipIncrement(WIP, this);
                if (wip != 0) {
                    if (wip == Integer.MIN_VALUE) {
                        if (this.sourceMode == 2) {
                            this.queue.clear();
                        } else {
                            Operators.onDiscardQueueWithClear(this.queue, this.currentContext(), null);
                        }
                    }
                    return;
                }
                try {
                    if (this.eventLoop.inEventLoop()) {
                        this.run();
                        return;
                    }
                    this.eventLoop.execute(this);
                }
                catch (Throwable t) {
                    if (!Operators.terminate(SUBSCRIPTION, this)) break block7;
                    this.onInterruptionCleanup();
                    this.actual.onError(Operators.onRejectedExecution(t, null, null, null, this.actualContext));
                }
            }
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return Operators.cancelledSubscription() == this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminalSignal != null;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue != null ? this.queue.size() : 0;
            }
            if (key == Scannable.Attr.ERROR) {
                return !this.hasOnComplete() ? this.terminalSignal : null;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 128;
            }
            return null;
        }

        @Override
        public Channel channel() {
            return this.ctx.channel();
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            this.trySuccess(null);
            return this;
        }

        @Override
        public ChannelPromise setSuccess() {
            this.trySuccess(null);
            return this;
        }

        @Override
        public boolean trySuccess() {
            this.trySuccess(null);
            return true;
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            if (this.tryFailure(cause)) {
                return this;
            }
            Operators.onErrorDropped(cause, this.actualContext);
            return this;
        }

        @Override
        public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return this;
        }

        @Override
        public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return this;
        }

        @Override
        public ChannelPromise sync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise syncUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise await() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise unvoid() {
            return new DefaultChannelPromise(this.ctx.channel()){

                @Override
                public ChannelPromise setSuccess(Void result) {
                    super.trySuccess(null);
                    this.trySuccess(null);
                    return this;
                }

                @Override
                public boolean trySuccess(Void result) {
                    super.trySuccess(null);
                    return this.trySuccess(null);
                }

                @Override
                public ChannelPromise setFailure(Throwable cause) {
                    super.tryFailure(cause);
                    this.tryFailure(cause);
                    return this;
                }

                @Override
                public boolean tryFailure(Throwable cause) {
                    super.tryFailure(cause);
                    return this.tryFailure(cause);
                }
            };
        }

        @Override
        public boolean isVoid() {
            return false;
        }

        @Override
        public boolean trySuccess(Void result) {
            --this.requested;
            --this.pending;
            if (this.checkTerminated()) {
                this.trySchedule();
                return true;
            }
            if (this.requested <= 64) {
                int u = 128 - this.requested;
                this.requested += u;
                this.nextRequest += u;
                this.trySchedule();
            }
            return true;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            if (Operators.terminate(SUBSCRIPTION, this)) {
                int wip = MonoSendMany.wipIncrement(WIP, this);
                if (wip == 0) {
                    this.onInterruptionCleanup();
                }
                this.actual.onError(cause);
            }
            return true;
        }

        @Override
        public boolean setUncancellable() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return this.hasOnComplete() && this.queue.isEmpty();
        }

        @Override
        public boolean isCancellable() {
            return false;
        }

        @Override
        @Nullable
        public Throwable cause() {
            return null;
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return false;
        }

        @Override
        public boolean await(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void getNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Void get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(I i) {
            try {
                this.parent.sourceCleanup.accept(i);
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
            Operators.onDiscard(i, this.actualContext);
        }

        @Override
        public <T> T get(Object key) {
            if (KEY_ON_DISCARD == key) {
                return (T)this;
            }
            return this.actualContext.get(key);
        }

        @Override
        public boolean hasKey(Object key) {
            if (KEY_ON_DISCARD == key) {
                return true;
            }
            return this.actualContext.hasKey(key);
        }

        @Override
        public Context put(Object key, Object value) {
            Context context = this.actualContext;
            if (context.isEmpty()) {
                if (key == KEY_ON_DISCARD) {
                    return Context.of(key, value);
                }
                return Context.of(KEY_ON_DISCARD, this, key, value);
            }
            return context.put(KEY_ON_DISCARD, this).put(key, value);
        }

        @Override
        public Context delete(Object key) {
            Context context = this.actualContext;
            if (context.isEmpty()) {
                if (key == KEY_ON_DISCARD) {
                    return Context.empty();
                }
                return this;
            }
            return context.put(KEY_ON_DISCARD, this).delete(key);
        }

        @Override
        public int size() {
            Context context = this.actualContext;
            if (context.hasKey(KEY_ON_DISCARD)) {
                return context.size();
            }
            return context.size() + 1;
        }

        @Override
        public Stream<Map.Entry<Object, Object>> stream() {
            Context context = this.actualContext;
            if (context.isEmpty()) {
                return Stream.of(new AbstractMap.SimpleEntry<Object, SendManyInner>(KEY_ON_DISCARD, this));
            }
            return context.put(KEY_ON_DISCARD, this).stream();
        }

        boolean hasOnComplete() {
            return this.terminalSignal == Completion.INSTANCE;
        }

        final class AsyncFlush
        implements Runnable {
            AsyncFlush() {
            }

            @Override
            public void run() {
                if (SendManyInner.this.pending != 0) {
                    SendManyInner.this.ctx.flush();
                }
            }
        }
    }
}

