/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty;

import com.microsoft.shaded.io.netty.util.concurrent.Future;
import com.microsoft.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.netty.channel.AbortedException;
import reactor.util.context.Context;

public abstract class FutureMono
extends Mono<Void> {
    public static <F extends Future<Void>> Mono<Void> from(F future) {
        Objects.requireNonNull(future, "future");
        if (future.isDone()) {
            if (!future.isSuccess()) {
                return Mono.error(FutureSubscription.wrapError(future.cause()));
            }
            return Mono.empty();
        }
        return new ImmediateFutureMono<F>(future);
    }

    public static <F extends Future<Void>> Mono<Void> deferFuture(Supplier<F> deferredFuture) {
        return new DeferredFutureMono<F>(deferredFuture);
    }

    static final class FutureSubscription<F extends Future<Void>>
    implements GenericFutureListener<F>,
    Subscription,
    Supplier<Context> {
        final CoreSubscriber<? super Void> s;
        final F future;

        FutureSubscription(F future, CoreSubscriber<? super Void> s) {
            this.s = s;
            this.future = future;
        }

        @Override
        public void request(long n) {
        }

        @Override
        public Context get() {
            return this.s.currentContext();
        }

        @Override
        public void cancel() {
            this.future.removeListener(this);
        }

        @Override
        public void operationComplete(F future) {
            if (!future.isSuccess()) {
                this.s.onError(FutureSubscription.wrapError(future.cause()));
            } else {
                this.s.onComplete();
            }
        }

        private static Throwable wrapError(Throwable error) {
            if (error instanceof ClosedChannelException) {
                return new AbortedException(error);
            }
            return error;
        }
    }

    static final class DeferredFutureMono<F extends Future<Void>>
    extends FutureMono {
        final Supplier<F> deferredFuture;

        DeferredFutureMono(Supplier<F> deferredFuture) {
            this.deferredFuture = Objects.requireNonNull(deferredFuture, "deferredFuture");
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            Future f;
            try {
                f = (Future)this.deferredFuture.get();
            }
            catch (Throwable t) {
                Operators.error(s, t);
                return;
            }
            if (f == null) {
                Operators.error(s, Operators.onOperatorError(new NullPointerException("Deferred supplied null"), s.currentContext()));
                return;
            }
            if (f.isDone()) {
                if (f.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, FutureSubscription.wrapError(f.cause()));
                }
                return;
            }
            FutureSubscription<Future> fs = new FutureSubscription<Future>(f, s);
            s.onSubscribe(fs);
            f.addListener(fs);
        }
    }

    static final class ImmediateFutureMono<F extends Future<Void>>
    extends FutureMono {
        final F future;

        ImmediateFutureMono(F future) {
            this.future = (Future)Objects.requireNonNull(future, "future");
        }

        @Override
        public final void subscribe(CoreSubscriber<? super Void> s) {
            if (this.future.isDone()) {
                if (this.future.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, FutureSubscription.wrapError(this.future.cause()));
                }
                return;
            }
            FutureSubscription<F> fs = new FutureSubscription<F>(this.future, s);
            this.future.addListener(fs);
            s.onSubscribe(fs);
        }
    }
}

