/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.shaded.io.netty.handler.codec.http.websocketx;

import com.microsoft.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.microsoft.shaded.io.netty.handler.codec.http.FullHttpRequest;
import com.microsoft.shaded.io.netty.handler.codec.http.FullHttpResponse;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpVersion;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.microsoft.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.microsoft.shaded.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker07
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_07_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocols, WebSocketDecoderConfig.newBuilder().allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(allowMaskMismatch).build());
    }

    public WebSocketServerHandshaker07(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        super(WebSocketVersion.V07, webSocketURL, subprotocols, decoderConfig);
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        String key = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY);
        if (key == null) {
            throw new WebSocketServerHandshakeException("not a WebSocket request: missing key", req);
        }
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, req.content().alloc().buffer(0));
        if (headers != null) {
            res.headers().add(headers);
        }
        String acceptSeed = key + WEBSOCKET_07_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 07 server handshake key: {}, response: {}.", (Object)key, (Object)accept);
        }
        res.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, (Object)accept);
        String subprotocols = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)subprotocols);
                }
            } else {
                res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubprotocol);
            }
        }
        return res;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket07FrameDecoder(this.decoderConfig());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket07FrameEncoder(false);
    }
}

