/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.shaded.io.netty.handler.codec.base64;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.channel.ChannelHandler;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import com.microsoft.shaded.io.netty.handler.codec.base64.Base64;
import com.microsoft.shaded.io.netty.handler.codec.base64.Base64Dialect;
import com.microsoft.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class Base64Encoder
extends MessageToMessageEncoder<ByteBuf> {
    private final boolean breakLines;
    private final Base64Dialect dialect;

    public Base64Encoder() {
        this(true);
    }

    public Base64Encoder(boolean breakLines) {
        this(breakLines, Base64Dialect.STANDARD);
    }

    public Base64Encoder(boolean breakLines, Base64Dialect dialect) {
        this.dialect = ObjectUtil.checkNotNull(dialect, "dialect");
        this.breakLines = breakLines;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        out.add(Base64.encode(msg, msg.readerIndex(), msg.readableBytes(), this.breakLines, this.dialect));
    }
}

