/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.shaded.io.netty.channel.kqueue;

import com.microsoft.shaded.io.netty.channel.Channel;
import com.microsoft.shaded.io.netty.channel.kqueue.AbstractKQueueChannel;
import com.microsoft.shaded.io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import com.microsoft.shaded.io.netty.channel.kqueue.BsdSocket;
import com.microsoft.shaded.io.netty.channel.kqueue.KQueueEventLoop;
import com.microsoft.shaded.io.netty.channel.kqueue.KQueueSocketChannelConfig;
import com.microsoft.shaded.io.netty.channel.socket.ServerSocketChannel;
import com.microsoft.shaded.io.netty.channel.socket.SocketChannel;
import com.microsoft.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;

public final class KQueueSocketChannel
extends AbstractKQueueStreamChannel
implements SocketChannel {
    private final KQueueSocketChannelConfig config = new KQueueSocketChannelConfig(this);

    public KQueueSocketChannel() {
        super(null, BsdSocket.newSocketStream(), false);
    }

    public KQueueSocketChannel(int fd) {
        super(new BsdSocket(fd));
    }

    KQueueSocketChannel(Channel parent, BsdSocket fd, InetSocketAddress remoteAddress) {
        super(parent, fd, remoteAddress);
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public KQueueSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    protected AbstractKQueueChannel.AbstractKQueueUnsafe newUnsafe() {
        return new KQueueSocketChannelUnsafe();
    }

    private final class KQueueSocketChannelUnsafe
    extends AbstractKQueueStreamChannel.KQueueStreamUnsafe {
        private KQueueSocketChannelUnsafe() {
        }

        @Override
        protected Executor prepareToClose() {
            try {
                if (KQueueSocketChannel.this.isOpen() && KQueueSocketChannel.this.config().getSoLinger() > 0) {
                    ((KQueueEventLoop)KQueueSocketChannel.this.eventLoop()).remove(KQueueSocketChannel.this);
                    return GlobalEventExecutor.INSTANCE;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

