/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import com.azure.core.util.CoreUtils;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasPermission;
import com.azure.storage.common.sas.AccountSasQueryParameters;
import com.azure.storage.common.sas.AccountSasResourceType;
import com.azure.storage.common.sas.AccountSasService;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;

public final class AccountSasSignatureValues {
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String services;
    private String resourceTypes;

    @Deprecated
    public AccountSasSignatureValues() {
    }

    public AccountSasSignatureValues(OffsetDateTime expiryTime, AccountSasPermission permissions, AccountSasService services, AccountSasResourceType resourceTypes) {
        StorageImplUtils.assertNotNull("expiryTime", expiryTime);
        StorageImplUtils.assertNotNull("services", services);
        StorageImplUtils.assertNotNull("permissions", permissions);
        StorageImplUtils.assertNotNull("resourceTypes", resourceTypes);
        this.expiryTime = expiryTime;
        this.services = services.toString();
        this.resourceTypes = resourceTypes.toString();
        this.permissions = permissions.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public AccountSasSignatureValues setVersion(String version) {
        this.version = version;
        return this;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public AccountSasSignatureValues setProtocol(SasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public AccountSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    @Deprecated
    public AccountSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public AccountSasSignatureValues setPermissions(AccountSasPermission permissions) {
        StorageImplUtils.assertNotNull("permissions", permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public AccountSasSignatureValues setSasIpRange(SasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    public String getServices() {
        return this.services;
    }

    @Deprecated
    public AccountSasSignatureValues setServices(String services) {
        this.services = services;
        return this;
    }

    public String getResourceTypes() {
        return this.resourceTypes;
    }

    @Deprecated
    public AccountSasSignatureValues setResourceTypes(String resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    @Deprecated
    public AccountSasQueryParameters generateSasQueryParameters(StorageSharedKeyCredential storageSharedKeyCredentials) {
        StorageImplUtils.assertNotNull("storageSharedKeyCredentials", storageSharedKeyCredentials);
        StorageImplUtils.assertNotNull("services", this.services);
        StorageImplUtils.assertNotNull("resourceTypes", this.resourceTypes);
        StorageImplUtils.assertNotNull("expiryTime", this.expiryTime);
        StorageImplUtils.assertNotNull("permissions", this.permissions);
        if (CoreUtils.isNullOrEmpty(this.version)) {
            this.version = "2020-08-04";
        }
        String signature = storageSharedKeyCredentials.computeHmac256(this.stringToSign(storageSharedKeyCredentials));
        return new AccountSasQueryParameters(this.version, this.services, this.resourceTypes, this.protocol, this.startTime, this.expiryTime, this.sasIpRange, this.permissions, signature);
    }

    private String stringToSign(StorageSharedKeyCredential storageSharedKeyCredentials) {
        return String.join((CharSequence)"\n", storageSharedKeyCredentials.getAccountName(), AccountSasPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
    }
}

