/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.connectionstring;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettings;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettingsFilter;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import java.net.URI;
import java.net.URISyntaxException;

final class StorageEmulatorConnectionString {
    StorageEmulatorConnectionString() {
    }

    static StorageConnectionString tryCreate(ConnectionSettings settings, ClientLogger logger) {
        if (ConnectionSettingsFilter.matchesSpecification(settings, StorageEmulatorConnectionString.requireUseEmulatorFlag(), StorageEmulatorConnectionString.optionalProxyUri())) {
            StorageConnectionString storageConnectionString;
            String host;
            String scheme;
            if (!StorageEmulatorConnectionString.parseUseEmulatorFlag(settings).booleanValue()) {
                throw logger.logExceptionAsError(new IllegalArgumentException("Invalid connection string, the 'UseDevelopmentStorage' key must always have the value 'true'. Remove the flag entirely otherwise."));
            }
            if (settings.hasSetting("DevelopmentStorageProxyUri")) {
                try {
                    URI devStoreProxyUri = new URI(settings.getSettingValue("DevelopmentStorageProxyUri"));
                    scheme = devStoreProxyUri.getScheme();
                    host = devStoreProxyUri.getHost();
                }
                catch (URISyntaxException use) {
                    throw logger.logExceptionAsError(new RuntimeException(use));
                }
            } else {
                scheme = "http";
                host = "127.0.0.1";
            }
            try {
                URI blobPrimaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1", scheme, host, "10000"));
                URI queuePrimaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1", scheme, host, "10001"));
                URI tablePrimaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1", scheme, host, "10002"));
                URI blobSecondaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1-secondary", scheme, host, "10000"));
                URI queueSecondaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1-secondary", scheme, host, "10001"));
                URI tableSecondaryEndpoint = new URI(String.format("%s://%s:%s/devstoreaccount1-secondary", scheme, host, "10002"));
                storageConnectionString = new StorageConnectionString(StorageAuthenticationSettings.forEmulator(), new StorageEndpoint(blobPrimaryEndpoint, blobSecondaryEndpoint), new StorageEndpoint(queuePrimaryEndpoint, queueSecondaryEndpoint), new StorageEndpoint(tablePrimaryEndpoint, tableSecondaryEndpoint), null, null);
            }
            catch (URISyntaxException use) {
                throw logger.logExceptionAsError(new RuntimeException(use));
            }
            return storageConnectionString;
        }
        return null;
    }

    private static ConnectionSettingsFilter requireUseEmulatorFlag() {
        return ConnectionSettingsFilter.allRequired("UseDevelopmentStorage");
    }

    private static ConnectionSettingsFilter optionalProxyUri() {
        return ConnectionSettingsFilter.optional("DevelopmentStorageProxyUri");
    }

    private static Boolean parseUseEmulatorFlag(ConnectionSettings settings) {
        return Boolean.parseBoolean(settings.getSettingValue("UseDevelopmentStorage"));
    }
}

