/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.connectionstring;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettings;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageEmulatorConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.implementation.connectionstring.StorageServiceConnectionString;

public final class StorageConnectionString {
    private final String accountName;
    private StorageAuthenticationSettings storageAuthSettings;
    private final StorageEndpoint blobEndpoint;
    private final StorageEndpoint fileEndpoint;
    private final StorageEndpoint queueEndpoint;
    private final StorageEndpoint tableEndpoint;

    public String getAccountName() {
        return this.accountName;
    }

    public StorageAuthenticationSettings getStorageAuthSettings() {
        return this.storageAuthSettings;
    }

    public StorageEndpoint getBlobEndpoint() {
        return this.blobEndpoint;
    }

    public StorageEndpoint getFileEndpoint() {
        return this.fileEndpoint;
    }

    public StorageEndpoint getQueueEndpoint() {
        return this.queueEndpoint;
    }

    public StorageEndpoint getTableEndpoint() {
        return this.tableEndpoint;
    }

    public static StorageConnectionString create(String connectionString, ClientLogger logger) {
        if (connectionString == null || connectionString.length() == 0) {
            throw logger.logExceptionAsError(new IllegalArgumentException("Invalid connection string."));
        }
        ConnectionSettings settings = ConnectionSettings.fromConnectionString(connectionString, logger);
        StorageConnectionString emulatorConnString = StorageEmulatorConnectionString.tryCreate(settings, logger);
        if (emulatorConnString != null) {
            return emulatorConnString;
        }
        StorageConnectionString serviceConnString = StorageServiceConnectionString.tryCreate(settings, logger);
        if (serviceConnString != null) {
            return serviceConnString;
        }
        throw logger.logExceptionAsError(new IllegalArgumentException("Invalid connection string."));
    }

    StorageConnectionString(StorageAuthenticationSettings storageAuthSettings, StorageEndpoint blobEndpoint, StorageEndpoint queueEndpoint, StorageEndpoint tableEndpoint, StorageEndpoint fileEndpoint, String accountName) {
        this.storageAuthSettings = storageAuthSettings;
        this.blobEndpoint = blobEndpoint;
        this.fileEndpoint = fileEndpoint;
        this.queueEndpoint = queueEndpoint;
        this.tableEndpoint = tableEndpoint;
        this.accountName = accountName;
    }
}

