/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BuilderHelper;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={AppendBlobClient.class, AppendBlobAsyncClient.class, BlockBlobClient.class, BlockBlobAsyncClient.class, PageBlobClient.class, PageBlobAsyncClient.class})
public final class SpecializedBlobClientBuilder {
    private final ClientLogger logger = new ClientLogger(SpecializedBlobClientBuilder.class);
    private String endpoint;
    private String accountName;
    private String containerName;
    private String blobName;
    private String snapshot;
    private String versionId;
    private CpkInfo customerProvidedKey;
    private EncryptionScope encryptionScope;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions = SpecializedBlobClientBuilder.getDefaultHttpLogOptions();
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private BlobServiceVersion version;

    public AppendBlobClient buildAppendBlobClient() {
        return new AppendBlobClient(this.buildAppendBlobAsyncClient());
    }

    public AppendBlobAsyncClient buildAppendBlobAsyncClient() {
        this.validateConstruction();
        String containerName = this.getContainerName();
        return new AppendBlobAsyncClient(this.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, containerName, this.blobName, this.snapshot, this.customerProvidedKey, this.encryptionScope, this.versionId);
    }

    public BlockBlobClient buildBlockBlobClient() {
        return new BlockBlobClient(this.buildBlockBlobAsyncClient());
    }

    public BlockBlobAsyncClient buildBlockBlobAsyncClient() {
        this.validateConstruction();
        String containerName = this.getContainerName();
        return new BlockBlobAsyncClient(this.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, containerName, this.blobName, this.snapshot, this.customerProvidedKey, this.encryptionScope, this.versionId);
    }

    public PageBlobClient buildPageBlobClient() {
        return new PageBlobClient(this.buildPageBlobAsyncClient());
    }

    public PageBlobAsyncClient buildPageBlobAsyncClient() {
        this.validateConstruction();
        String containerName = this.getContainerName();
        return new PageBlobAsyncClient(this.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, containerName, this.blobName, this.snapshot, this.customerProvidedKey, this.encryptionScope, this.versionId);
    }

    private void validateConstruction() {
        Objects.requireNonNull(this.blobName, "'blobName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null");
        BuilderHelper.httpsValidation(this.customerProvidedKey, "customer provided key", this.endpoint, this.logger);
        if (Objects.nonNull(this.customerProvidedKey) && Objects.nonNull(this.encryptionScope)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Customer provided key and encryptionscope cannot both be set"));
        }
    }

    private String getContainerName() {
        return CoreUtils.isNullOrEmpty(this.containerName) ? "$root" : this.containerName;
    }

    private HttpPipeline getHttpPipeline() {
        return this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger);
    }

    private BlobServiceVersion getServiceVersion() {
        return this.version != null ? this.version : BlobServiceVersion.getLatest();
    }

    public SpecializedBlobClientBuilder blobClient(BlobClientBase blobClient) {
        this.pipeline(blobClient.getHttpPipeline());
        this.endpoint(blobClient.getBlobUrl());
        this.serviceVersion(blobClient.getServiceVersion());
        this.snapshot = blobClient.getSnapshotId();
        this.versionId = blobClient.getVersionId();
        this.customerProvidedKey = blobClient.getCustomerProvidedKey();
        if (blobClient.getEncryptionScope() != null) {
            this.encryptionScope = new EncryptionScope().setEncryptionScope(blobClient.getEncryptionScope());
        }
        return this;
    }

    public SpecializedBlobClientBuilder blobAsyncClient(BlobAsyncClientBase blobAsyncClient) {
        this.pipeline(blobAsyncClient.getHttpPipeline());
        this.endpoint(blobAsyncClient.getBlobUrl());
        this.serviceVersion(blobAsyncClient.getServiceVersion());
        this.snapshot = blobAsyncClient.getSnapshotId();
        this.versionId = blobAsyncClient.getVersionId();
        this.customerProvidedKey = blobAsyncClient.getCustomerProvidedKey();
        if (blobAsyncClient.getEncryptionScope() != null) {
            this.encryptionScope = new EncryptionScope().setEncryptionScope(blobAsyncClient.getEncryptionScope());
        }
        return this;
    }

    public SpecializedBlobClientBuilder containerClient(BlobContainerClient blobContainerClient, String blobName) {
        this.pipeline(blobContainerClient.getHttpPipeline());
        this.endpoint(blobContainerClient.getBlobContainerUrl());
        this.serviceVersion(blobContainerClient.getServiceVersion());
        this.blobName(blobName);
        this.customerProvidedKey = blobContainerClient.getCustomerProvidedKey();
        if (blobContainerClient.getEncryptionScope() != null) {
            this.encryptionScope = new EncryptionScope().setEncryptionScope(blobContainerClient.getEncryptionScope());
        }
        return this;
    }

    public SpecializedBlobClientBuilder containerAsyncClient(BlobContainerAsyncClient blobContainerAsyncClient, String blobName) {
        this.pipeline(blobContainerAsyncClient.getHttpPipeline());
        this.endpoint(blobContainerAsyncClient.getBlobContainerUrl());
        this.serviceVersion(blobContainerAsyncClient.getServiceVersion());
        this.blobName(blobName);
        this.customerProvidedKey = blobContainerAsyncClient.getCustomerProvidedKey();
        if (blobContainerAsyncClient.getEncryptionScope() != null) {
            this.encryptionScope = new EncryptionScope().setEncryptionScope(blobContainerAsyncClient.getEncryptionScope());
        }
        return this;
    }

    public SpecializedBlobClientBuilder endpoint(String endpoint) {
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse(url);
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            this.containerName = parts.getBlobContainerName();
            this.blobName = Utility.urlEncode(parts.getBlobName());
            this.snapshot = parts.getSnapshot();
            this.versionId = parts.getVersionId();
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("The Azure Storage Blob endpoint url is malformed."));
        }
        return this;
    }

    public SpecializedBlobClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey == null ? null : new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        return this;
    }

    public SpecializedBlobClientBuilder encryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope == null ? null : new EncryptionScope().setEncryptionScope(encryptionScope);
        return this;
    }

    public SpecializedBlobClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public SpecializedBlobClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public SpecializedBlobClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public SpecializedBlobClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public SpecializedBlobClientBuilder setAnonymousAccess() {
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        this.sasToken = null;
        return this;
    }

    public SpecializedBlobClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create(connectionString, this.logger);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("connectionString missing required settings to derive blob service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public SpecializedBlobClientBuilder containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public SpecializedBlobClientBuilder blobName(String blobName) {
        this.blobName = Utility.urlEncode(Utility.urlDecode(Objects.requireNonNull(blobName, "'blobName' cannot be null.")));
        return this;
    }

    public SpecializedBlobClientBuilder snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public SpecializedBlobClientBuilder versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public SpecializedBlobClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public SpecializedBlobClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public SpecializedBlobClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public SpecializedBlobClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SpecializedBlobClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public SpecializedBlobClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SpecializedBlobClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public SpecializedBlobClientBuilder serviceVersion(BlobServiceVersion version) {
        this.version = version;
        return this;
    }
}

