/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.BlockBlobsCommitBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsPutBlobFromUrlHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsUploadHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.options.BlobUploadFromUrlOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.options.BlockBlobListBlocksOptions;
import com.azure.storage.blob.options.BlockBlobSimpleUploadOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=SpecializedBlobClientBuilder.class, isAsync=true)
public final class BlockBlobAsyncClient
extends BlobAsyncClientBase {
    private final ClientLogger logger = new ClientLogger(BlockBlobAsyncClient.class);
    @Deprecated
    public static final int MAX_UPLOAD_BLOB_BYTES = 0x10000000;
    public static final long MAX_UPLOAD_BLOB_BYTES_LONG = 5242880000L;
    @Deprecated
    public static final int MAX_STAGE_BLOCK_BYTES = 0x6400000;
    public static final long MAX_STAGE_BLOCK_BYTES_LONG = 0xFA000000L;
    public static final int MAX_BLOCKS = 50000;

    BlockBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    @Override
    public BlockBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new BlockBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public BlockBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new BlockBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, long length) {
        try {
            return this.upload(data, length, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, long length, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, long length, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, byte[] contentMd5, BlobRequestConditions requestConditions) {
        return this.uploadWithResponse(new BlockBlobSimpleUploadOptions(data, length).setHeaders(headers).setMetadata(metadata).setTier(tier).setContentMd5(contentMd5).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(BlockBlobSimpleUploadOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<BlockBlobItem>> uploadWithResponse(BlockBlobSimpleUploadOptions options, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        Flux<ByteBuffer> data = options.getDataFlux() == null ? Utility.convertStreamToByteBuffer(options.getDataStream(), options.getLength(), 0x400000, true).subscribeOn(Schedulers.boundedElastic()) : options.getDataFlux();
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getBlockBlobs().uploadWithResponseAsync(this.containerName, this.blobName, options.getLength(), data, null, options.getContentMd5(), options.getMetadata(), requestConditions.getLeaseId(), options.getTier(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.tagsToString(options.getTags()), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            BlockBlobsUploadHeaders hd = (BlockBlobsUploadHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsVersionId());
            return new SimpleResponse<BlockBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> uploadFromUrl(String sourceUrl) {
        try {
            return this.uploadFromUrl(sourceUrl, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> uploadFromUrl(String sourceUrl, boolean overwrite) {
        try {
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            if (!overwrite) {
                blobRequestConditions.setIfNoneMatch("*");
            }
            return this.uploadFromUrlWithResponse(new BlobUploadFromUrlOptions(sourceUrl).setDestinationRequestConditions(blobRequestConditions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<BlockBlobItem>> uploadFromUrlWithResponse(BlobUploadFromUrlOptions options, Context context) {
        URL url;
        StorageImplUtils.assertNotNull("options", options);
        BlobRequestConditions destinationRequestConditions = options.getDestinationRequestConditions() == null ? new BlobRequestConditions() : options.getDestinationRequestConditions();
        BlobRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new BlobRequestConditions() : options.getSourceRequestConditions();
        context = context == null ? Context.NONE : context;
        try {
            url = new URL(options.getSourceUrl());
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        return this.azureBlobStorage.getBlockBlobs().putBlobFromUrlWithResponseAsync(this.containerName, this.blobName, 0L, url, null, null, null, destinationRequestConditions.getLeaseId(), options.getTier(), destinationRequestConditions.getIfModifiedSince(), destinationRequestConditions.getIfUnmodifiedSince(), destinationRequestConditions.getIfMatch(), destinationRequestConditions.getIfNoneMatch(), destinationRequestConditions.getTagsConditions(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), sourceRequestConditions.getTagsConditions(), null, options.getContentMd5(), this.tagsToString(options.getTags()), options.isCopySourceBlobProperties(), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            BlockBlobsPutBlobFromUrlHeaders hd = (BlockBlobsPutBlobFromUrlHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsVersionId());
            return new SimpleResponse<BlockBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlock(String base64BlockId, Flux<ByteBuffer> data, long length) {
        try {
            return this.stageBlockWithResponse(base64BlockId, data, length, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockWithResponse(String base64BlockId, Flux<ByteBuffer> data, long length, byte[] contentMd5, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.stageBlockWithResponse(base64BlockId, data, length, contentMd5, leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<Void>> stageBlockWithResponse(String base64BlockId, Flux<ByteBuffer> data, long length, byte[] contentMd5, String leaseId, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getBlockBlobs().stageBlockWithResponseAsync(this.containerName, this.blobName, base64BlockId, length, data, contentMd5, null, null, leaseId, null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(response -> new SimpleResponse<Object>((Response<?>)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stageBlockFromUrl(String base64BlockId, String sourceUrl, BlobRange sourceRange) {
        try {
            return this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.stageBlockFromUrlWithResponse(base64BlockId, sourceUrl, sourceRange, sourceContentMd5, leaseId, sourceRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<Void>> stageBlockFromUrlWithResponse(String base64BlockId, String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, String leaseId, BlobRequestConditions sourceRequestConditions, Context context) {
        URL url;
        sourceRange = sourceRange == null ? new BlobRange(0L) : sourceRange;
        sourceRequestConditions = sourceRequestConditions == null ? new BlobRequestConditions() : sourceRequestConditions;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'sourceUrl' is not a valid url."));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getBlockBlobs().stageBlockFromURLWithResponseAsync(this.containerName, this.blobName, base64BlockId, 0L, url, sourceRange.toHeaderValue(), sourceContentMd5, null, null, leaseId, sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(response -> new SimpleResponse<Object>((Response<?>)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockList> listBlocks(BlockListType listType) {
        try {
            return this.listBlocksWithResponse(listType, null).map(Response::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockList>> listBlocksWithResponse(BlockListType listType, String leaseId) {
        try {
            return this.listBlocksWithResponse(new BlockBlobListBlocksOptions(listType).setLeaseId(leaseId));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockList>> listBlocksWithResponse(BlockBlobListBlocksOptions options) {
        try {
            return FluxUtil.withContext(context -> this.listBlocksWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<BlockList>> listBlocksWithResponse(BlockBlobListBlocksOptions options, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        return this.azureBlobStorage.getBlockBlobs().getBlockListWithResponseAsync(this.containerName, this.blobName, options.getType(), this.getSnapshotId(), null, options.getLeaseId(), options.getIfTagsMatch(), null, context).map(response -> new SimpleResponse<BlockList>((Response<?>)response, response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> commitBlockList(List<String> base64BlockIds) {
        try {
            return this.commitBlockList(base64BlockIds, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> commitBlockList(List<String> base64BlockIds, boolean overwrite) {
        try {
            BlobRequestConditions requestConditions = null;
            if (!overwrite) {
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return this.commitBlockListWithResponse(base64BlockIds, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> commitBlockListWithResponse(List<String> base64BlockIds, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(base64BlockIds).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options) {
        try {
            return FluxUtil.withContext(context -> this.commitBlockListWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(this.logger, ex);
        }
    }

    Mono<Response<BlockBlobItem>> commitBlockListWithResponse(BlockBlobCommitBlockListOptions options, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getBlockBlobs().commitBlockListWithResponseAsync(this.containerName, this.blobName, new BlockLookupList().setLatest(options.getBase64BlockIds()), null, null, null, options.getMetadata(), requestConditions.getLeaseId(), options.getTier(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.tagsToString(options.getTags()), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            BlockBlobsCommitBlockListHeaders hd = (BlockBlobsCommitBlockListHeaders)rb.getDeserializedHeaders();
            BlockBlobItem item = new BlockBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsVersionId());
            return new SimpleResponse<BlockBlobItem>((Response<?>)rb, item);
        });
    }
}

