/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.common.StorageInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class BlobInputStream
extends StorageInputStream {
    private final BlobAsyncClientBase blobClient;
    private final BlobRequestConditions accessCondition;
    private final BlobProperties properties;

    BlobInputStream(BlobAsyncClientBase blobClient, long blobRangeOffset, Long blobRangeLength, int chunkSize, BlobRequestConditions accessCondition, BlobProperties blobProperties) throws BlobStorageException {
        super(blobRangeOffset, blobRangeLength, chunkSize, blobProperties.getBlobSize());
        this.blobClient = blobClient;
        this.accessCondition = accessCondition;
        this.properties = blobProperties;
    }

    @Override
    protected synchronized ByteBuffer dispatchRead(int readLength, long offset) throws IOException {
        try {
            ByteBuffer currentBuffer = (ByteBuffer)this.blobClient.downloadWithResponse(new BlobRange(offset, Long.valueOf(readLength)), null, this.accessCondition, false).flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)response.getValue()).map(ByteBuffer::wrap)).block();
            this.bufferSize = readLength;
            this.bufferStartOffset = offset;
            return currentBuffer;
        }
        catch (BlobStorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException(e);
            throw this.lastError;
        }
    }

    public BlobProperties getProperties() {
        return this.properties;
    }
}

