/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.common.ParallelTransferOptions;
import java.util.function.BiFunction;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple3;

public class ChunkedDownloadUtils {
    public static Mono<Tuple3<Long, BlobRequestConditions, BlobDownloadAsyncResponse>> downloadFirstChunk(BlobRange range, ParallelTransferOptions parallelTransferOptions, BlobRequestConditions requestConditions, BiFunction<BlobRange, BlobRequestConditions, Mono<BlobDownloadAsyncResponse>> downloader, boolean eTagLock) {
        long initialChunkSize = range.getCount() != null && range.getCount() < parallelTransferOptions.getBlockSizeLong() ? range.getCount() : parallelTransferOptions.getBlockSizeLong();
        return downloader.apply(new BlobRange(range.getOffset(), initialChunkSize), requestConditions).subscribeOn(Schedulers.elastic()).flatMap(response -> {
            BlobRequestConditions newConditions = eTagLock ? ChunkedDownloadUtils.setEtag(requestConditions, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getETag()) : requestConditions;
            long totalLength = ChunkedDownloadUtils.extractTotalBlobLength(((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentRange());
            long newCount = range.getCount() == null || range.getCount() > totalLength - range.getOffset() ? totalLength - range.getOffset() : range.getCount();
            return Mono.zip(Mono.just(newCount), Mono.just(newConditions), Mono.just(response));
        }).onErrorResume(BlobStorageException.class, blobStorageException -> {
            if (blobStorageException.getErrorCode() == BlobErrorCode.INVALID_RANGE && ChunkedDownloadUtils.extractTotalBlobLength(blobStorageException.getResponse().getHeaders().getValue("Content-Range")) == 0L) {
                return ((Mono)downloader.apply(new BlobRange(0L, 0L), requestConditions)).subscribeOn(Schedulers.elastic()).flatMap(response -> {
                    if (response.getStatusCode() != 200) {
                        Mono.error(new IllegalStateException("Blob was modified mid download. It was originally 0 bytes and is now larger."));
                    }
                    return Mono.zip(Mono.just(0L), Mono.just(requestConditions), Mono.just(response));
                });
            }
            return Mono.error(blobStorageException);
        });
    }

    public static <T> Flux<T> downloadChunk(Integer chunkNum, BlobDownloadAsyncResponse initialResponse, BlobRange finalRange, ParallelTransferOptions finalParallelTransferOptions, BlobRequestConditions requestConditions, long newCount, BiFunction<BlobRange, BlobRequestConditions, Mono<BlobDownloadAsyncResponse>> downloader, Function<BlobDownloadAsyncResponse, Flux<T>> returnTransformer) {
        if (chunkNum == 0) {
            return returnTransformer.apply(initialResponse);
        }
        long modifier = chunkNum.longValue() * finalParallelTransferOptions.getBlockSizeLong();
        long chunkSizeActual = Math.min(finalParallelTransferOptions.getBlockSizeLong(), newCount - modifier);
        BlobRange chunkRange = new BlobRange(finalRange.getOffset() + modifier, chunkSizeActual);
        return downloader.apply(chunkRange, requestConditions).subscribeOn(Schedulers.elastic()).flatMapMany(returnTransformer);
    }

    private static BlobRequestConditions setEtag(BlobRequestConditions requestConditions, String etag) {
        return new BlobRequestConditions().setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfModifiedSince()).setIfMatch(etag).setIfNoneMatch(requestConditions.getIfNoneMatch()).setLeaseId(requestConditions.getLeaseId());
    }

    public static long extractTotalBlobLength(String contentRange) {
        return Long.parseLong(contentRange.split("/")[1]);
    }

    public static int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }
}

