/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.blob.implementation.AppendBlobsImpl;
import com.azure.storage.blob.implementation.BlobsImpl;
import com.azure.storage.blob.implementation.BlockBlobsImpl;
import com.azure.storage.blob.implementation.ContainersImpl;
import com.azure.storage.blob.implementation.DirectoriesImpl;
import com.azure.storage.blob.implementation.PageBlobsImpl;
import com.azure.storage.blob.implementation.ServicesImpl;
import com.azure.storage.blob.models.PathRenameMode;

public final class AzureBlobStorageImpl {
    private final String url;
    private final String version;
    private final PathRenameMode pathRenameMode;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final ContainersImpl containers;
    private final DirectoriesImpl directories;
    private final BlobsImpl blobs;
    private final PageBlobsImpl pageBlobs;
    private final AppendBlobsImpl appendBlobs;
    private final BlockBlobsImpl blockBlobs;

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public PathRenameMode getPathRenameMode() {
        return this.pathRenameMode;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public ContainersImpl getContainers() {
        return this.containers;
    }

    public DirectoriesImpl getDirectories() {
        return this.directories;
    }

    public BlobsImpl getBlobs() {
        return this.blobs;
    }

    public PageBlobsImpl getPageBlobs() {
        return this.pageBlobs;
    }

    public AppendBlobsImpl getAppendBlobs() {
        return this.appendBlobs;
    }

    public BlockBlobsImpl getBlockBlobs() {
        return this.blockBlobs;
    }

    AzureBlobStorageImpl(String url, String version, PathRenameMode pathRenameMode) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()).build(), JacksonAdapter.createDefaultSerializerAdapter(), url, version, pathRenameMode);
    }

    AzureBlobStorageImpl(HttpPipeline httpPipeline, String url, String version, PathRenameMode pathRenameMode) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), url, version, pathRenameMode);
    }

    AzureBlobStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String url, String version, PathRenameMode pathRenameMode) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.url = url;
        this.version = version;
        this.pathRenameMode = pathRenameMode;
        this.services = new ServicesImpl(this);
        this.containers = new ContainersImpl(this);
        this.directories = new DirectoriesImpl(this);
        this.blobs = new BlobsImpl(this);
        this.pageBlobs = new PageBlobsImpl(this);
        this.appendBlobs = new AppendBlobsImpl(this);
        this.blockBlobs = new BlockBlobsImpl(this);
    }
}

