/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.sas.BlobServiceSasQueryParameters;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.sas.CommonSasQueryParameters;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class BlobUrlParts {
    private final ClientLogger logger = new ClientLogger(BlobUrlParts.class);
    private String scheme;
    private String host;
    private String containerName;
    private String blobName;
    private String snapshot;
    private String versionId;
    private String accountName;
    private boolean isIpUrl;
    private CommonSasQueryParameters commonSasQueryParameters;
    private Map<String, String[]> unparsedParameters = new HashMap<String, String[]>();

    public String getAccountName() {
        return this.accountName;
    }

    public BlobUrlParts setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public BlobUrlParts setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public BlobUrlParts setHost(String host) {
        this.host = host;
        try {
            this.isIpUrl = ModelHelper.determineAuthorityIsIpStyle(host);
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsError(new IllegalStateException("Authority is malformed. Host: " + host));
        }
        return this;
    }

    public String getBlobContainerName() {
        return this.containerName;
    }

    public BlobUrlParts setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public String getBlobName() {
        return this.blobName == null ? null : Utility.urlDecode(this.blobName);
    }

    public BlobUrlParts setBlobName(String blobName) {
        this.blobName = Utility.urlEncode(Utility.urlDecode(blobName));
        return this;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public BlobUrlParts setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public BlobUrlParts setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @Deprecated
    public BlobServiceSasQueryParameters getSasQueryParameters() {
        String encodedSas = this.commonSasQueryParameters.encode();
        return new BlobServiceSasQueryParameters(SasImplUtils.parseQueryString(encodedSas), true);
    }

    @Deprecated
    public BlobUrlParts setSasQueryParameters(BlobServiceSasQueryParameters blobServiceSasQueryParameters) {
        String encodedBlobSas = blobServiceSasQueryParameters.encode();
        this.commonSasQueryParameters = new CommonSasQueryParameters(SasImplUtils.parseQueryString(encodedBlobSas), true);
        return this;
    }

    public CommonSasQueryParameters getCommonSasQueryParameters() {
        return this.commonSasQueryParameters;
    }

    public BlobUrlParts setCommonSasQueryParameters(CommonSasQueryParameters commonSasQueryParameters) {
        this.commonSasQueryParameters = commonSasQueryParameters;
        return this;
    }

    public BlobUrlParts parseSasQueryParameters(String queryParams) {
        this.commonSasQueryParameters = new CommonSasQueryParameters(SasImplUtils.parseQueryString(queryParams), true);
        return this;
    }

    public Map<String, String[]> getUnparsedParameters() {
        return this.unparsedParameters;
    }

    public BlobUrlParts setUnparsedParameters(Map<String, String[]> unparsedParameters) {
        this.unparsedParameters = unparsedParameters;
        return this;
    }

    public URL toUrl() {
        Object encodedSAS;
        UrlBuilder url = new UrlBuilder().setScheme(this.scheme).setHost(this.host);
        StringBuilder path = new StringBuilder();
        if (CoreUtils.isNullOrEmpty(this.containerName) && this.blobName != null) {
            this.containerName = "$root";
        }
        if (this.isIpUrl) {
            path.append(this.accountName);
        }
        if (this.containerName != null) {
            path.append("/").append(this.containerName);
            if (this.blobName != null) {
                path.append("/").append(this.blobName);
            }
        }
        url.setPath(path.toString());
        if (this.snapshot != null) {
            url.setQueryParameter("snapshot", this.snapshot);
        }
        if (this.versionId != null) {
            url.setQueryParameter("versionid", this.versionId);
        }
        if (this.commonSasQueryParameters != null && ((String)(encodedSAS = this.commonSasQueryParameters.encode())).length() != 0) {
            url.setQuery((String)encodedSAS);
        }
        for (Map.Entry entry : this.unparsedParameters.entrySet()) {
            url.setQueryParameter((String)entry.getKey(), Utility.urlEncode(String.join((CharSequence)",", (CharSequence[])entry.getValue())));
        }
        try {
            return url.toUrl();
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError(new IllegalStateException("The URL parts created a malformed URL.", ex));
        }
    }

    public static BlobUrlParts parse(String url) {
        try {
            return BlobUrlParts.parse(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL format. URL: " + url);
        }
    }

    public static BlobUrlParts parse(URL url) {
        String[] versionIdArray;
        BlobUrlParts parts = new BlobUrlParts().setScheme(url.getProtocol());
        try {
            if (ModelHelper.determineAuthorityIsIpStyle(url.getAuthority())) {
                BlobUrlParts.parseIpUrl(url, parts);
            } else {
                BlobUrlParts.parseNonIpUrl(url, parts);
            }
        }
        catch (MalformedURLException e) {
            throw parts.logger.logExceptionAsError(new IllegalStateException("Authority is malformed. Host: " + url.getAuthority()));
        }
        Map<String, String[]> queryParamsMap = SasImplUtils.parseQueryString(url.getQuery());
        String[] snapshotArray = queryParamsMap.remove("snapshot");
        if (snapshotArray != null) {
            parts.setSnapshot(snapshotArray[0]);
        }
        if ((versionIdArray = queryParamsMap.remove("versionid")) != null) {
            parts.setVersionId(versionIdArray[0]);
        }
        CommonSasQueryParameters commonSasQueryParameters = new CommonSasQueryParameters(queryParamsMap, true);
        return parts.setCommonSasQueryParameters(commonSasQueryParameters).setUnparsedParameters(queryParamsMap);
    }

    private static void parseIpUrl(URL url, BlobUrlParts parts) {
        parts.setHost(url.getAuthority());
        String path = url.getPath();
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String[] pathPieces = path.split("/", 3);
        parts.setAccountName(pathPieces[0]);
        if (pathPieces.length >= 3) {
            parts.setContainerName(pathPieces[1]);
            parts.setBlobName(pathPieces[2]);
        } else if (pathPieces.length == 2) {
            parts.setContainerName(pathPieces[1]);
        }
        parts.isIpUrl = true;
    }

    private static void parseNonIpUrl(URL url, BlobUrlParts parts) {
        String path;
        String host = url.getHost();
        parts.setHost(host);
        if (!CoreUtils.isNullOrEmpty(host)) {
            int accountNameIndex = host.indexOf(46);
            if (accountNameIndex == -1) {
                parts.setAccountName(host);
            } else {
                parts.setAccountName(host.substring(0, accountNameIndex));
            }
        }
        if (!CoreUtils.isNullOrEmpty(path = url.getPath())) {
            int containerEndIndex;
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if ((containerEndIndex = path.indexOf(47)) == -1) {
                parts.setContainerName(path);
            } else {
                parts.setContainerName(path.substring(0, containerEndIndex));
                parts.setBlobName(path.substring(containerEndIndex + 1));
            }
        }
        parts.isIpUrl = false;
    }
}

