/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.logging.ClientLogger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final com.microsoft.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;

    public NettyToAzureCoreHttpHeadersWrapper(com.microsoft.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    @Override
    public int getSize() {
        return this.nettyHeaders.size();
    }

    @Override
    public HttpHeaders set(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpHeaders set(String name, List<String> values) {
        if (name == null) {
            return this;
        }
        if (values == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, (Iterable<?>)values);
        }
        return this;
    }

    HttpHeaders add(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.add(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpHeader get(String name) {
        if (this.nettyHeaders.contains(name)) {
            return new NettyHttpHeader(this, name, this.nettyHeaders.getAll(name));
        }
        return null;
    }

    @Override
    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        this.nettyHeaders.remove(name);
        return header;
    }

    @Override
    public String getValue(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public String[] getValues(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValues();
    }

    @Override
    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new AbstractMap<String, String>(){
                private final Map<String, String> innerJoinMap = new HashMap<String, String>();

                @Override
                public int size() {
                    return NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.size();
                }

                @Override
                public boolean isEmpty() {
                    return NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.isEmpty();
                }

                @Override
                public boolean containsKey(Object key) {
                    return NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.contains((String)key);
                }

                @Override
                public boolean containsValue(Object value) {
                    throw LOGGER.logExceptionAsWarning(new UnsupportedOperationException());
                }

                @Override
                public String get(Object key) {
                    return this.innerJoinMap.computeIfAbsent((String)key, _key -> String.join((CharSequence)",", NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.getAll((String)_key)));
                }

                @Override
                public String put(String key, String value) {
                    throw LOGGER.logExceptionAsWarning(new UnsupportedOperationException());
                }

                @Override
                public String remove(Object key) {
                    throw LOGGER.logExceptionAsWarning(new UnsupportedOperationException());
                }

                @Override
                public void putAll(Map<? extends String, ? extends String> m) {
                    throw LOGGER.logExceptionAsWarning(new UnsupportedOperationException());
                }

                @Override
                public void clear() {
                    throw LOGGER.logExceptionAsWarning(new UnsupportedOperationException());
                }

                @Override
                public Set<Map.Entry<String, String>> entrySet() {
                    return new AbstractSet<Map.Entry<String, String>>(){

                        @Override
                        public Iterator<Map.Entry<String, String>> iterator() {
                            return NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.iteratorAsString();
                        }

                        @Override
                        public int size() {
                            return NettyToAzureCoreHttpHeadersWrapper.this.nettyHeaders.size();
                        }
                    };
                }
            };
        }
        return this.abstractMap;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll((String)name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values) {
            super(name, values);
            this.allHeaders = allHeaders;
        }

        @Override
        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }
}

