/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import com.microsoft.shaded.io.netty.buffer.ByteBufAllocator;
import com.microsoft.shaded.io.netty.buffer.PooledByteBufAllocator;
import com.microsoft.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import com.microsoft.shaded.io.netty.channel.Channel;
import com.microsoft.shaded.io.netty.channel.ChannelFactory;
import com.microsoft.shaded.io.netty.channel.ChannelHandler;
import com.microsoft.shaded.io.netty.channel.ChannelInitializer;
import com.microsoft.shaded.io.netty.channel.ChannelOption;
import com.microsoft.shaded.io.netty.channel.ChannelPipeline;
import com.microsoft.shaded.io.netty.channel.EventLoopGroup;
import com.microsoft.shaded.io.netty.channel.group.ChannelGroup;
import com.microsoft.shaded.io.netty.handler.logging.LoggingHandler;
import com.microsoft.shaded.io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.ByteBufAllocatorMetrics;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class TransportConfig {
    Map<AttributeKey<?>, ?> attrs;
    Supplier<? extends SocketAddress> bindAddress;
    ChannelGroup channelGroup;
    ChannelPipelineConfigurer doOnChannelInit;
    LoggingHandler loggingHandler;
    LoopResources loopResources;
    ChannelMetricsRecorder metricsRecorder;
    ConnectionObserver observer;
    Map<ChannelOption<?>, ?> options;
    boolean preferNative;
    static final Logger log = Loggers.getLogger(TransportConfig.class);

    public final Map<AttributeKey<?>, ?> attributes() {
        if (this.attrs.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attrs);
    }

    @Nullable
    public final Supplier<? extends SocketAddress> bindAddress() {
        return this.bindAddress;
    }

    public int channelHash() {
        return Objects.hash(this.attrs, this.bindAddress != null ? this.bindAddress.get() : Integer.valueOf(0), this.channelGroup, this.doOnChannelInit, this.loggingHandler, this.loopResources, this.metricsRecorder, this.observer, this.options, this.preferNative);
    }

    @Nullable
    public final ChannelGroup channelGroup() {
        return this.channelGroup;
    }

    public final ChannelInitializer<Channel> channelInitializer(ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
        Objects.requireNonNull(connectionObserver, "connectionObserver");
        return new TransportChannelInitializer(this, connectionObserver, remoteAddress, onServer);
    }

    public ChannelOperations.OnSetup channelOperationsProvider() {
        return ChannelOperations.OnSetup.empty();
    }

    public final ConnectionObserver connectionObserver() {
        return this.observer;
    }

    public final ChannelPipelineConfigurer doOnChannelInit() {
        return this.doOnChannelInit;
    }

    public final boolean isPreferNative() {
        return this.preferNative;
    }

    @Nullable
    public final LoggingHandler loggingHandler() {
        return this.loggingHandler;
    }

    public final LoopResources loopResources() {
        return this.loopResources != null ? this.loopResources : this.defaultLoopResources();
    }

    @Nullable
    public final Supplier<? extends ChannelMetricsRecorder> metricsRecorder() {
        return this.metricsRecorder != null ? () -> this.metricsRecorder : null;
    }

    public final Map<ChannelOption<?>, ?> options() {
        if (this.options.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.options);
    }

    protected TransportConfig(Map<ChannelOption<?>, ?> options) {
        this.attrs = Collections.emptyMap();
        this.doOnChannelInit = ChannelPipelineConfigurer.emptyConfigurer();
        this.observer = ConnectionObserver.emptyListener();
        this.options = Objects.requireNonNull(options, "options");
        this.preferNative = LoopResources.DEFAULT_NATIVE;
    }

    protected TransportConfig(Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> bindAddress) {
        this.attrs = Collections.emptyMap();
        this.bindAddress = Objects.requireNonNull(bindAddress, "bindAddress");
        this.doOnChannelInit = ChannelPipelineConfigurer.emptyConfigurer();
        this.observer = ConnectionObserver.emptyListener();
        this.options = Objects.requireNonNull(options, "options");
        this.preferNative = LoopResources.DEFAULT_NATIVE;
    }

    protected TransportConfig(TransportConfig parent) {
        this.attrs = parent.attrs;
        this.bindAddress = parent.bindAddress;
        this.channelGroup = parent.channelGroup;
        this.doOnChannelInit = parent.doOnChannelInit;
        this.loggingHandler = parent.loggingHandler;
        this.loopResources = parent.loopResources;
        this.metricsRecorder = parent.metricsRecorder;
        this.observer = parent.observer;
        this.options = parent.options;
        this.preferNative = parent.preferNative;
    }

    protected abstract Class<? extends Channel> channelType(boolean var1);

    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        return () -> this.loopResources().onChannel(this.channelType(isDomainSocket), elg);
    }

    protected abstract ConnectionObserver defaultConnectionObserver();

    protected abstract LoggingHandler defaultLoggingHandler();

    protected abstract LoopResources defaultLoopResources();

    protected abstract ChannelMetricsRecorder defaultMetricsRecorder();

    protected abstract ChannelPipelineConfigurer defaultOnChannelInit();

    protected abstract EventLoopGroup eventLoopGroup();

    protected void loggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    protected void metricsRecorder(@Nullable Supplier<? extends ChannelMetricsRecorder> metricsRecorderSupplier) {
        this.metricsRecorder = metricsRecorderSupplier != null ? metricsRecorderSupplier.get() : null;
    }

    protected ChannelMetricsRecorder metricsRecorderInternal() {
        return this.metricsRecorder;
    }

    protected static <K, V> Map<K, V> updateMap(Map<K, V> parentMap, Object key, @Nullable Object value) {
        if (parentMap.isEmpty()) {
            return value == null ? parentMap : Collections.singletonMap(key, value);
        }
        HashMap<Object, Object> attrs = new HashMap<Object, Object>(parentMap.size() + 1);
        attrs.putAll(parentMap);
        if (value == null) {
            attrs.remove(key);
        } else {
            attrs.put(key, value);
        }
        return attrs;
    }

    static final class TransportChannelInitializer
    extends ChannelInitializer<Channel> {
        final TransportConfig config;
        final ConnectionObserver connectionObserver;
        final boolean onServer;
        final SocketAddress remoteAddress;

        TransportChannelInitializer(TransportConfig config, ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
            this.config = config;
            this.connectionObserver = connectionObserver;
            this.onServer = onServer;
            this.remoteAddress = remoteAddress;
        }

        @Override
        protected void initChannel(Channel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.config.metricsRecorder != null) {
                ChannelOperations.addMetricsHandler(channel, this.config.metricsRecorder, this.remoteAddress, this.onServer);
                ByteBufAllocator alloc = channel.alloc();
                if (alloc instanceof PooledByteBufAllocator) {
                    ByteBufAllocatorMetrics.INSTANCE.registerMetrics("pooled", ((PooledByteBufAllocator)alloc).metric());
                } else if (alloc instanceof UnpooledByteBufAllocator) {
                    ByteBufAllocatorMetrics.INSTANCE.registerMetrics("unpooled", ((UnpooledByteBufAllocator)alloc).metric());
                }
            }
            if (this.config.loggingHandler != null) {
                pipeline.addFirst("reactor.left.loggingHandler", (ChannelHandler)this.config.loggingHandler);
            }
            ChannelOperations.addReactiveBridge(channel, this.config.channelOperationsProvider(), this.connectionObserver);
            this.config.defaultOnChannelInit().then(this.config.doOnChannelInit).onChannelInit(this.connectionObserver, channel, this.remoteAddress);
            pipeline.remove(this);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Initialized pipeline {}"), pipeline.toString());
            }
        }
    }
}

