/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import com.microsoft.shaded.io.netty.channel.ChannelOption;
import com.microsoft.shaded.io.netty.util.NetUtil;
import java.util.Collections;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientConfig;
import reactor.netty.transport.AddressUtils;

final class TcpClientConnect
extends TcpClient {
    final TcpClientConfig config;
    static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;

    TcpClientConnect(ConnectionProvider provider) {
        this.config = new TcpClientConfig(provider, Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> AddressUtils.createUnresolved(NetUtil.LOCALHOST.getHostAddress(), DEFAULT_PORT));
    }

    TcpClientConnect(TcpClientConfig config) {
        this.config = config;
    }

    @Override
    public TcpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected TcpClient duplicate() {
        return new TcpClientConnect(new TcpClientConfig(this.config));
    }
}

