/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import com.microsoft.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

public final class DefaultSslContextSpec
extends AbstractProtocolSslContextSpec<DefaultSslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> {};

    public static DefaultSslContextSpec forClient() {
        return new DefaultSslContextSpec(SslContextBuilder.forClient());
    }

    public static DefaultSslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile));
    }

    public static DefaultSslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyCertChainFile, keyFile, keyPassword));
    }

    public static DefaultSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream));
    }

    public static DefaultSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyCertChainInputStream, keyInputStream, keyPassword));
    }

    public static DefaultSslContextSpec forServer(KeyManager keyManager) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyManager));
    }

    public static DefaultSslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(keyManagerFactory));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(key, keyPassword, keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer(key, keyCertChain));
    }

    DefaultSslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public DefaultSslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

