/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.channel.ChannelPromise;
import com.microsoft.shaded.io.netty.handler.codec.DecoderException;
import com.microsoft.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import com.microsoft.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import com.microsoft.shaded.io.netty.handler.codec.http.FullHttpRequest;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpContentCompressor;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpRequest;
import com.microsoft.shaded.io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;

final class SimpleCompressionHandler
extends HttpContentCompressor {
    SimpleCompressionHandler() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            super.write(ctx, new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void decode(ChannelHandlerContext ctx, HttpRequest msg) {
        ArrayList<Object> out = new ArrayList<Object>();
        HttpRequest request = msg;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).content().refCnt() == 0) {
                request = new DefaultHttpRequest(msg.protocolVersion(), msg.method(), msg.uri(), msg.headers());
            }
            super.decode(ctx, request, (List<Object>)out);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            ReferenceCountUtil.release(request);
            out.clear();
        }
    }
}

