/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.channel.ChannelDuplexHandler;
import com.microsoft.shaded.io.netty.channel.ChannelFuture;
import com.microsoft.shaded.io.netty.channel.ChannelFutureListener;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.channel.ChannelPromise;
import com.microsoft.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import com.microsoft.shaded.io.netty.handler.codec.http.HttpRequest;
import com.microsoft.shaded.io.netty.handler.codec.http.LastHttpContent;
import com.microsoft.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.microsoft.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.microsoft.shaded.io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.HAProxyMessageReader;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.annotation.Nullable;

final class Http2StreamBridgeServerHandler
extends ChannelDuplexHandler
implements ChannelFutureListener {
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ConnectionObserver listener;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    SocketAddress remoteAddress;
    Boolean secured;

    Http2StreamBridgeServerHandler(ConnectionObserver listener, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle) {
        this.compress = compress;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.listener = listener;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.mapHandle = mapHandle;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New HTTP/2 stream"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(ctx.channel().parent().remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            try {
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, this.compress, request, ConnectionInfo.from(ctx.channel().parent(), request, this.secured, this.remoteAddress, this.forwardedHeaderHandler), this.cookieEncoder, this.cookieDecoder, this.mapHandle, this.secured);
            }
            catch (RuntimeException e) {
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, this.secured, e, msg);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                f.addListener(this);
            }
        }
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Last HTTP packet was sent, terminating the channel"));
        }
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }
}

