/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import reactor.netty.http.client.ContextAwareHttpClientMetricsRecorder;
import reactor.util.annotation.Nullable;

final class ContextAwareHttpClientMetricsHandler
extends AbstractHttpClientMetricsHandler {
    final ContextAwareHttpClientMetricsRecorder recorder;

    ContextAwareHttpClientMetricsHandler(ContextAwareHttpClientMetricsRecorder recorder, @Nullable Function<String, String> uriTagValue) {
        super(uriTagValue);
        this.recorder = recorder;
    }

    @Override
    protected ContextAwareHttpClientMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(ChannelHandlerContext ctx) {
        if (this.contextView != null) {
            this.recorder().incrementErrorsCount(this.contextView, ctx.channel().remoteAddress(), this.path);
        } else {
            super.recordException(ctx);
        }
    }

    @Override
    protected void recordWrite(SocketAddress address) {
        if (this.contextView != null) {
            this.recorder.recordDataSentTime(this.contextView, address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder.recordDataSent(this.contextView, address, this.path, this.dataSent);
        } else {
            super.recordWrite(address);
        }
    }

    @Override
    protected void recordRead(SocketAddress address) {
        if (this.contextView != null) {
            this.recorder.recordDataReceivedTime(this.contextView, address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder.recordResponseTime(this.contextView, address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder.recordDataReceived(this.contextView, address, this.path, this.dataReceived);
        } else {
            super.recordRead(address);
        }
    }
}

