/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import com.microsoft.shaded.io.netty.buffer.ByteBuf;
import com.microsoft.shaded.io.netty.channel.ChannelDuplexHandler;
import com.microsoft.shaded.io.netty.channel.ChannelHandler;
import com.microsoft.shaded.io.netty.channel.ChannelHandlerContext;
import com.microsoft.shaded.io.netty.channel.ChannelPromise;
import com.microsoft.shaded.io.netty.channel.socket.DatagramPacket;
import java.net.SocketAddress;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.annotation.Nullable;

public abstract class AbstractChannelMetricsHandler
extends ChannelDuplexHandler {
    final SocketAddress remoteAddress;
    final boolean onServer;

    protected AbstractChannelMetricsHandler(@Nullable SocketAddress remoteAddress, boolean onServer) {
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.onServer) {
            ctx.pipeline().addAfter("reactor.left.channelMetricsHandler", "reactor.left.connectMetricsHandler", this.connectMetricsHandler());
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recordRead(ctx, this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            this.recordRead(ctx, this.remoteAddress != null ? this.remoteAddress : p.sender(), buffer.readableBytes());
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recordWrite(ctx, this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            this.recordWrite(ctx, this.remoteAddress != null ? this.remoteAddress : p.recipient(), buffer.readableBytes());
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recordException(ctx, this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress());
        ctx.fireExceptionCaught(cause);
    }

    public abstract ChannelHandler connectMetricsHandler();

    public abstract ChannelMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        this.recorder().incrementErrorsCount(address);
    }

    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataReceived(address, bytes);
    }

    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        this.recorder().recordDataSent(address, bytes);
    }
}

