/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AzureCliCredential;
import com.azure.identity.AzurePowerShellCredential;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.DefaultAzureCredential;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.IntelliJCredential;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.SharedTokenCacheCredential;
import com.azure.identity.VisualStudioCodeCredential;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;

public class DefaultAzureCredentialBuilder
extends CredentialBuilderBase<DefaultAzureCredentialBuilder> {
    private String tenantId;
    private String managedIdentityClientId;
    private final ClientLogger logger = new ClientLogger(DefaultAzureCredentialBuilder.class);

    public DefaultAzureCredentialBuilder() {
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.tenantId = configuration.get("AZURE_TENANT_ID");
        this.managedIdentityClientId = configuration.get("AZURE_CLIENT_ID");
    }

    public DefaultAzureCredentialBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DefaultAzureCredentialBuilder authorityHost(String authorityHost) {
        this.identityClientOptions.setAuthorityHost(authorityHost);
        return this;
    }

    public DefaultAzureCredentialBuilder intelliJKeePassDatabasePath(String databasePath) {
        if (CoreUtils.isNullOrEmpty(databasePath)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("The KeePass database path is either empty or not configured. Please configure it on the builder."));
        }
        this.identityClientOptions.setIntelliJKeePassDatabasePath(databasePath);
        return this;
    }

    public DefaultAzureCredentialBuilder managedIdentityClientId(String clientId) {
        this.managedIdentityClientId = clientId;
        return this;
    }

    public DefaultAzureCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public DefaultAzureCredential build() {
        return new DefaultAzureCredential(this.getCredentialsChain());
    }

    private ArrayList<TokenCredential> getCredentialsChain() {
        ArrayList<TokenCredential> output = new ArrayList<TokenCredential>(6);
        output.add(new EnvironmentCredential(this.identityClientOptions));
        output.add(new ManagedIdentityCredential(this.managedIdentityClientId, this.identityClientOptions));
        output.add(new SharedTokenCacheCredential(null, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", this.tenantId, this.identityClientOptions));
        output.add(new IntelliJCredential(this.tenantId, this.identityClientOptions));
        output.add(new VisualStudioCodeCredential(this.tenantId, this.identityClientOptions));
        output.add(new AzureCliCredential(this.identityClientOptions));
        output.add(new AzurePowerShellCredential(this.identityClientOptions));
        return output;
    }
}

