/*
 * Copyright (C) 2022 HopsWorks AB.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hdfs.server.namenode.cloud.sync;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.CloudProvider;
import org.apache.hadoop.hdfs.server.namenode.cloud.TestClouds;
import org.junit.AfterClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.io.IOException;
import java.util.Collection;

@RunWith(Parameterized.class)
public class TestCloudAppendAndSyncDNFailure3 extends AppendAndSyncDNFailureHelper {

  static final Log LOG = LogFactory.getLog(TestCloudAppendAndSyncDNFailure3.class);
  static String testBucketPrefix = "hops-test-TCASDNF3";

  @Parameterized.Parameters
  public static Collection<Object> configs() {
    return TestClouds.CloudProviders;
  }

  CloudProvider defaultCloudProvider = null;

  public TestCloudAppendAndSyncDNFailure3(CloudProvider cloudProvider) {
    this.defaultCloudProvider = cloudProvider;
  }

  @Rule
  public TestName testname = new TestName();

  @ClassRule
  public static Timeout classTimeout = Timeout.seconds(60 * 15);

  @Rule
  public Timeout timeout = Timeout.seconds(60 * 15);

  /*
  Test dn failure recovery with hsync or hflush multiple block
   */
  @Test
  public void TestAppendAndHsyncDNFailure2() throws IOException {
    final int BLK_SIZE = 32 * 1024 * 1024;
    final int INIT_SIZE = 128 * 1024;
    final int APPEND_SIZE = BLK_SIZE;
    testAppendAndHsyncDNFailure(testname.getMethodName(), defaultCloudProvider, testBucketPrefix,
      true, BLK_SIZE, INIT_SIZE, APPEND_SIZE);
  }

  @AfterClass
  public static void CleanUp() throws IOException {
    TestClouds.DeleteAllBuckets(testBucketPrefix);
  }
}
