package org.apache.hadoop.hdfs.server.namenode.cloud;

import org.apache.hadoop.fs.CloudProvider;
import org.apache.hadoop.hdfs.CloudTestHelper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class TestClouds {
  public static Collection CloudProviders = Arrays.asList(new Object[][]{
          {CloudProvider.AWS},
          {CloudProvider.GCS},
          {CloudProvider.AZURE}
  });

  public static void DeleteAllBuckets(String prefix) throws IOException {
    DeleteAllBuckets(prefix, TestClouds.CloudProviders);
  }

  public static void DeleteAllBuckets(String prefix, Collection<Object>
                                      cloudProviders) throws IOException {
    Iterator<Object> itr = cloudProviders.iterator();
    while (itr.hasNext()) {
      Object[] obj = (Object[]) itr.next();
      CloudTestHelper.purgeCloudData((CloudProvider) obj[0], prefix);
    }
  }
}
