/*
 * Copyright (C) 2021 Logical Clocks AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.hops.transaction.lock;

import io.hops.metadata.hdfs.entity.ProvidedBlockCacheLoc;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class ProvidedBlockCacheLocLock extends Lock {

  @Override
  protected void acquire(TransactionLocks locks) throws IOException {
    Lock lock = locks.getLock(Type.Block);
    if (lock instanceof BaseIndividualBlockLock) {
      BaseIndividualBlockLock individualBlockLock =
              (BaseIndividualBlockLock) lock;
      //
      Set<Long> blockIds = new HashSet<>();
      for (BlockInfoContiguous blk : individualBlockLock.getBlocks()) {
        blockIds.add(blk.getBlockId());
      }

      if (blockIds.size() > 0) {
         Collection<ProvidedBlockCacheLoc> list =
                 (Collection<ProvidedBlockCacheLoc>) acquireLockList(DEFAULT_LOCK_TYPE,
                ProvidedBlockCacheLoc.Finder.ByBlockIds,
                blockIds.toArray(new Long[blockIds.size()]));
      }
    } else {
      throw new TransactionLocks.LockNotAddedException(
              "Block Lock wasn't added");
    }
  }

  @Override
  protected Type getType() {
    return Type.ProvidedBlkCacheLoc;
  }
}
