/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.yarn.entity.quota;

import java.util.HashSet;
import java.util.Set;

public class ProjectDailyCost {
    private String projectName;
    private String projectUser;
    private long day;
    private float creditsUsed;
    private Set<String> appIds = new HashSet<String>();

    public ProjectDailyCost(String projectName, String projectUser, long day, float creditsUsed, String appIds) {
        this.projectName = projectName;
        this.projectUser = projectUser;
        this.day = day;
        this.creditsUsed = creditsUsed;
        for (String appId : appIds.split(",")) {
            if (appId.isEmpty()) continue;
            this.appIds.add(appId);
        }
    }

    public String toString() {
        return "YarnProjectsQuota{projectName=" + this.projectName + ", user=" + this.projectUser + ", day=" + this.day + ", credit=" + this.creditsUsed + " }";
    }

    public void incrementCharge(float inc, String appId) {
        this.creditsUsed += inc;
        this.appIds.add(appId);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectUser() {
        return this.projectUser;
    }

    public long getDay() {
        return this.day;
    }

    public float getCreditsUsed() {
        return this.creditsUsed;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProjectUser(String projectUser) {
        this.projectUser = projectUser;
    }

    public void setDay(long day) {
        this.day = day;
    }

    public void setCreditsUsed(float creditsUsed) {
        this.creditsUsed = creditsUsed;
    }

    public Set<String> getAppIds() {
        return this.appIds;
    }
}

