/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;

public class CachedBlock {
    private final long blockId;
    private final long inodeId;
    private final String datanodeId;
    private final String status;
    private final short replicationAndMark;

    public CachedBlock(long blockId, long inodeId, String datanodeId, String status, short replicationAndMark) {
        this.blockId = blockId;
        this.inodeId = inodeId;
        this.datanodeId = datanodeId;
        this.status = status;
        this.replicationAndMark = replicationAndMark;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public long getInodeId() {
        return this.inodeId;
    }

    public String getDatanodeId() {
        return this.datanodeId;
    }

    public String getStatus() {
        return this.status;
    }

    public short getReplicationAndMark() {
        return this.replicationAndMark;
    }

    public static enum Finder implements FinderType<CachedBlock>
    {
        ByBlockIdAndInodeId,
        ByInodeId,
        ByInodeIds,
        ByBlockIdInodeIdAndDatanodeId,
        ByBlockIdsAndINodeIds,
        ByDatanodeId,
        All,
        ByDatanodeAndTypes;


        @Override
        public Class getType() {
            return CachedBlock.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndInodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByInodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByBlockIdInodeIdAndDatanodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByInodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
                case ByBlockIdsAndINodeIds: {
                    return FinderType.Annotation.Batched;
                }
                case ByDatanodeId: {
                    return FinderType.Annotation.IndexScan;
                }
                case All: {
                    return FinderType.Annotation.FullTable;
                }
                case ByDatanodeAndTypes: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

