/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.common.entity;

import io.hops.metadata.common.entity.Variable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteArrayVariable
extends Variable {
    private byte[] value = new byte[0];

    public ByteArrayVariable(Variable.Finder type, byte[] value) {
        this(type);
        if (value != null && value.length > 255) {
            throw new IllegalArgumentException("byte array shouldn't exceed 255 bytes");
        }
        this.value = value;
    }

    public ByteArrayVariable(Variable.Finder type) {
        super(type);
    }

    public ByteArrayVariable(byte[] value) {
        this(Variable.Finder.GenericByteArray, value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(byte[] val) {
        if (val == null || val.length == 0) {
            return;
        }
        ByteBuffer buf = ByteBuffer.wrap(val);
        byte len = buf.get();
        if (len == 0) {
            return;
        }
        this.value = new byte[len];
        buf.get(this.value);
    }

    @Override
    public byte[] getBytes() {
        int length = this.getLength();
        if (length > 0) {
            ByteBuffer buf = ByteBuffer.allocate(this.getLength());
            buf.put((byte)this.value.length);
            buf.put(this.value);
            return buf.array();
        }
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)0);
        return buf.array();
    }

    @Override
    public int getLength() {
        if (this.value == null) {
            return -1;
        }
        return this.value.length + 1;
    }

    protected void setByteArrayValue(byte[] val) {
        this.value = val;
    }

    protected byte[] getByteArrayValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayVariable that = (ByteArrayVariable)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

