/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FileBasedKeyStoresFactory
implements KeyStoresFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedKeyStoresFactory.class);
    public static final String SSL_KEYSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.keystore.reload.interval";
    public static final String SSL_KEYSTORE_RELOAD_TIMEUNIT_TPL_KEY = "ssl.{0}.keystore.reload.timeunit";
    public static final String SSL_KEYSTORE_LOCATION_TPL_KEY = "ssl.{0}.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD_TPL_KEY = "ssl.{0}.keystore.password";
    public static final String SSL_KEYSTORE_KEYPASSWORD_TPL_KEY = "ssl.{0}.keystore.keypassword";
    public static final String SSL_KEYSTORE_TYPE_TPL_KEY = "ssl.{0}.keystore.type";
    public static final String SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY = "ssl.{0}.truststore.reload.interval";
    public static final String SSL_TRUSTSTORE_LOCATION_TPL_KEY = "ssl.{0}.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD_TPL_KEY = "ssl.{0}.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_TPL_KEY = "ssl.{0}.truststore.type";
    public static final String SSL_EXCLUDE_CIPHER_LIST = "ssl.{0}.exclude.cipher.list";
    public static final String SSL_PASSWORDFILE_LOCATION_TPL_KEY = "ssl.{0}.passwordfile.location";
    public static final String DEFAULT_KEYSTORE_TYPE = "jks";
    public static final int DEFAULT_SSL_TRUSTSTORE_RELOAD_INTERVAL = 10000;
    public static final long DEFAULT_SSL_KEYSTORE_RELOAD_INTERVAL = 10000L;
    public static final String DEFAULT_SSL_KEYSTORE_RELOAD_TIMEUNIT = "MILLISECONDS";
    private Configuration conf;
    private KeyManager[] keyManagers;
    private ReloadingX509KeyManager keyManager;
    private TrustManager[] trustManagers;
    private ReloadingX509TrustManager trustManager;

    @VisibleForTesting
    public static String resolvePropertyName(SSLFactory.Mode mode, String template) {
        return MessageFormat.format(template, StringUtils.toLowerCase(mode.toString()));
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        this.createKeyManagers(mode);
        this.createTrustManagers(mode);
    }

    private void createKeyManagers(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        boolean requireClientCert = this.conf.getBoolean("hadoop.ssl.require.client.cert", false);
        String keystoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String keystoreKeyPassword = null;
        if (requireClientCert || mode == SSLFactory.Mode.SERVER) {
            String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_LOCATION_TPL_KEY);
            String keystoreLocation = this.conf.get(locationProperty, "");
            if (keystoreLocation.isEmpty()) {
                throw new GeneralSecurityException("The property '" + locationProperty + "' has not been set in the ssl configuration file.");
            }
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_PASSWORD_TPL_KEY);
            String keystorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (keystorePassword.isEmpty()) {
                throw new GeneralSecurityException("The property '" + passwordProperty + "' has not been set in the ssl configuration file.");
            }
            String keyPasswordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_KEYPASSWORD_TPL_KEY);
            keystoreKeyPassword = this.getPassword(this.conf, keyPasswordProperty, keystorePassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug(mode.toString() + " KeyStore: " + keystoreLocation);
            }
            long keyStoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
            String timeUnitStr = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_KEYSTORE_RELOAD_TIMEUNIT_TPL_KEY), DEFAULT_SSL_KEYSTORE_RELOAD_TIMEUNIT);
            TimeUnit reloadTimeUnit = TimeUnit.valueOf(timeUnitStr.toUpperCase());
            String passwordFileLocationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_PASSWORDFILE_LOCATION_TPL_KEY);
            String passwordFileLocation = this.conf.get(passwordFileLocationProperty, null);
            this.keyManager = new ReloadingX509KeyManager(keystoreType, keystoreLocation, keystorePassword, passwordFileLocation, keystoreKeyPassword, keyStoreReloadInterval, reloadTimeUnit);
            this.keyManager.init();
            if (LOG.isDebugEnabled()) {
                LOG.debug(mode.toString() + " Loaded KeyStore: " + keystoreLocation);
            }
            this.keyManagers = new KeyManager[]{this.keyManager};
        } else {
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(null, null);
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
            keyMgrFactory.init(keyStore, null);
            this.keyManagers = keyMgrFactory.getKeyManagers();
        }
    }

    private void createTrustManagers(SSLFactory.Mode mode) throws IOException, GeneralSecurityException {
        String truststoreType = this.conf.get(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_TYPE_TPL_KEY), DEFAULT_KEYSTORE_TYPE);
        String locationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_LOCATION_TPL_KEY);
        String truststoreLocation = this.conf.get(locationProperty, "");
        String passwordFileLocationProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_PASSWORDFILE_LOCATION_TPL_KEY);
        String passwordFileLocation = this.conf.get(passwordFileLocationProperty, null);
        if (!truststoreLocation.isEmpty()) {
            String passwordProperty = FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_PASSWORD_TPL_KEY);
            String truststorePassword = this.getPassword(this.conf, passwordProperty, "");
            if (truststorePassword.isEmpty()) {
                truststorePassword = null;
            }
            long truststoreReloadInterval = this.conf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(mode, SSL_TRUSTSTORE_RELOAD_INTERVAL_TPL_KEY), 10000L);
            if (LOG.isDebugEnabled()) {
                LOG.debug(mode.toString() + " TrustStore: " + truststoreLocation);
            }
            this.trustManager = new ReloadingX509TrustManager(truststoreType, truststoreLocation, truststorePassword, passwordFileLocation, truststoreReloadInterval);
            this.trustManager.init();
            if (LOG.isDebugEnabled()) {
                LOG.debug(mode.toString() + " Loaded TrustStore: " + truststoreLocation);
            }
            this.trustManagers = new TrustManager[]{this.trustManager};
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The property '" + locationProperty + "' has not been set, no TrustStore will be loaded");
            }
            this.trustManagers = null;
        }
    }

    String getPassword(Configuration conf, String alias, String defaultPass) {
        String password = defaultPass;
        try {
            char[] passchars = conf.getPassword(alias);
            if (passchars != null) {
                password = new String(passchars);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Exception while trying to get password for alias " + alias + ": " + ioe.getMessage());
        }
        return password;
    }

    @Override
    public synchronized void destroy() {
        if (this.trustManager != null) {
            this.trustManager.destroy();
            this.trustManager = null;
            this.trustManagers = null;
        }
        if (this.keyManager != null) {
            this.keyManager.stop();
            this.keyManager = null;
            this.keyManagers = null;
        }
    }

    @Override
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Override
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }
}

