/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.CRLValidator;

public class CRLValidatorFactory {
    private final Map<TYPE, CRLValidator> validatorInstances = new ConcurrentHashMap<TYPE, CRLValidator>();
    private static volatile CRLValidatorFactory instance = null;

    private CRLValidatorFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRLValidatorFactory getInstance() {
        if (instance != null) return instance;
        Class<CRLValidatorFactory> clazz = CRLValidatorFactory.class;
        synchronized (CRLValidatorFactory.class) {
            if (instance != null) return instance;
            instance = new CRLValidatorFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized CRLValidator getValidator(TYPE type, Configuration conf, Configuration sslConf) throws GeneralSecurityException, IOException {
        if (type.equals((Object)TYPE.NORMAL)) {
            if (this.validatorInstances.containsKey((Object)TYPE.NORMAL)) {
                return this.validatorInstances.get((Object)TYPE.NORMAL);
            }
            CRLValidator validator = new CRLValidator(conf, sslConf);
            validator.startReloadingThread();
            this.validatorInstances.putIfAbsent(TYPE.NORMAL, validator);
            return this.validatorInstances.get((Object)TYPE.NORMAL);
        }
        if (type.equals((Object)TYPE.TESTING)) {
            if (this.validatorInstances.containsKey((Object)TYPE.TESTING)) {
                return this.validatorInstances.get((Object)TYPE.TESTING);
            }
            CRLValidator testingValidator = new CRLValidator(conf, sslConf);
            testingValidator.setReloadTimeunit(TimeUnit.SECONDS);
            testingValidator.setReloadInterval(1L);
            testingValidator.setCertificateFactory(CertificateFactory.getInstance("X.509", "BC"));
            testingValidator.startReloadingThread();
            this.validatorInstances.putIfAbsent(TYPE.TESTING, testingValidator);
            return this.validatorInstances.get((Object)TYPE.TESTING);
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)type) + " of CRL validator is not supported");
    }

    @VisibleForTesting
    public void registerValidator(TYPE type, CRLValidator crlValidator) {
        this.validatorInstances.put(type, crlValidator);
    }

    @VisibleForTesting
    public void clearCache() {
        for (CRLValidator validator : this.validatorInstances.values()) {
            validator.stopReloaderThread();
        }
        this.validatorInstances.clear();
    }

    public static enum TYPE {
        NORMAL,
        TESTING;

    }
}

