/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.security.ssl.CRLFetcher;

public abstract class CRLFetcherAbstr
implements CRLFetcher {
    private static final Set<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
    protected URI inputURI;
    private URI outputURI;
    private Path outputPath;
    private boolean permissionsSet = false;

    @Override
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @Override
    public URI getOutputURI() {
        return this.outputURI;
    }

    @Override
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
        this.outputPath = Paths.get(outputURI);
    }

    protected void writeToFile(ReadableByteChannel sourceChannel) throws FileNotFoundException, IOException {
        FileOutputStream outputStream = new FileOutputStream(this.outputPath.toFile());
        outputStream.getChannel().transferFrom(sourceChannel, 0L, Long.MAX_VALUE);
        if (!this.permissionsSet) {
            this.permissionsSet = true;
            Set<PosixFilePermission> filePermissions = Files.getPosixFilePermissions(this.outputPath, LinkOption.NOFOLLOW_LINKS);
            if (!filePermissions.containsAll(permissions)) {
                Files.setPosixFilePermissions(this.outputPath, permissions);
            }
        }
    }
}

