/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import io.hops.security.HopsUtil;
import io.hops.security.SuperuserKeystoresLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.net.hopssslchecks.SSLMaterialAlreadyConfiguredException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;

public class SuperUserHopsSSLCheck
extends AbstractHopsSSLCheck {
    private static final Log LOG = LogFactory.getLog(SuperUserHopsSSLCheck.class);

    public SuperUserHopsSSLCheck() {
        super(-1);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperUsers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        String username = ugi.getUserName();
        if (proxySuperUsers.contains(username)) {
            try {
                this.isConfigurationNeededForSuperUser(username, configuration);
            }
            catch (SSLMaterialAlreadyConfiguredException ex) {
                return new HopsSSLCryptoMaterial(configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Found crypto material with the hostname");
            }
            if (certificateLocalization != null) {
                return new HopsSSLCryptoMaterial(certificateLocalization.getSuperKeystoreLocation(), certificateLocalization.getSuperKeystorePass(), certificateLocalization.getSuperKeyPassword(), certificateLocalization.getSuperTruststoreLocation(), certificateLocalization.getSuperTruststorePass(), certificateLocalization.getSuperMaterialPasswordFile(), true);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"*** Called setTlsConfiguration for superuser but CertificateLocalization is NULL");
            }
            return this.getSuperuserMaterialFromFile(configuration);
        }
        return null;
    }

    private HopsSSLCryptoMaterial getSuperuserMaterialFromFile(Configuration conf) throws IOException {
        SuperuserKeystoresLoader loader = new SuperuserKeystoresLoader(conf);
        X509SecurityMaterial material = loader.loadSuperUserMaterial();
        if (!(this.fileExists(material.getKeyStoreLocation()) && this.fileExists(material.getTrustStoreLocation()) && this.fileExists(material.getPasswdLocation()))) {
            throw new IOException("Could not load Keystore/Truststore/Password file from " + material.getKeyStoreLocation().getParent() + " . Check your permissions or configuration");
        }
        String password = HopsUtil.readCryptoMaterialPassword(material.getPasswdLocation().toFile());
        return new HopsSSLCryptoMaterial(material.getKeyStoreLocation().toString(), password, password, material.getTrustStoreLocation().toString(), password, material.getPasswdLocation().toString(), true);
    }

    private boolean fileExists(Path path2file) {
        return path2file.toFile().exists();
    }
}

