/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import io.hops.security.HopsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;

public class LocalResourceHopsSSLCheck
extends AbstractHopsSSLCheck {
    private static final Log LOG = LogFactory.getLog(LocalResourceHopsSSLCheck.class);

    public LocalResourceHopsSSLCheck() {
        super(100);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperusers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        Path localizedKeystorePath;
        String configuredKeystorePath = configuration.get("hops.ssl.keystore.name", "k_certificate");
        String configuredTrustorePath = configuration.get("hops.ssl.trustore.name", "t_certificate");
        String configuredPasswordPath = configuration.get("hops.ssl.keystores.passwd.name", "material_passwd");
        File localizedKeystore = new File(configuredKeystorePath);
        File trustore = new File(configuredTrustorePath);
        File password = new File(configuredPasswordPath);
        if (localizedKeystore.exists() && trustore.exists() && password.exists()) {
            LOG.debug((Object)"Crypto material found att configured path");
            return this.constructCryptoMaterial(localizedKeystore, trustore, password);
        }
        String keystoreName = Paths.get(configuredKeystorePath, new String[0]).getFileName().toString();
        String trustoreName = Paths.get(configuredTrustorePath, new String[0]).getFileName().toString();
        String passwordName = Paths.get(configuredPasswordPath, new String[0]).getFileName().toString();
        localizedKeystore = new File(keystoreName);
        if (localizedKeystore.exists()) {
            LOG.debug((Object)"Crypto material found in container's CWD");
            return this.constructCryptoMaterial(localizedKeystore, new File(trustoreName), new File(passwordName));
        }
        String pwd = EnvironmentVariablesFactory.getInstance().getEnv("PWD");
        if (pwd != null && (localizedKeystorePath = Paths.get(pwd, keystoreName)).toFile().exists()) {
            LOG.debug((Object)"Crypto material found in PWD");
            return this.constructCryptoMaterial(localizedKeystorePath.toFile(), Paths.get(pwd, trustoreName).toFile(), Paths.get(pwd, passwordName).toFile());
        }
        return null;
    }

    private HopsSSLCryptoMaterial constructCryptoMaterial(File keystoreLocation, File truststoreLocation, File passwordFileLocation) throws IOException {
        String password = HopsUtil.readCryptoMaterialPassword(passwordFileLocation);
        return new HopsSSLCryptoMaterial(keystoreLocation.toString(), password, password, truststoreLocation.toString(), password, passwordFileLocation.toString(), true);
    }
}

